/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

final class AccumulatingReporter
implements ErrorReporter {
    private boolean hasErrors;
    @NotNull
    private final List<Warning> warnings = new ArrayList();

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    public final void setHasErrors(boolean bl) {
        this.hasErrors = bl;
    }

    @NotNull
    public final List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(endPosition, "endPosition");
        ((Collection)this.warnings).add(new Warning(message, startPosition, endPosition));
    }

    @Override
    public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(endPosition, "endPosition");
        this.hasErrors = true;
    }

    public static final class Warning {
        @NotNull
        private final String message;
        @NotNull
        private final CodePosition startPosition;
        @NotNull
        private final CodePosition endPosition;

        public Warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
            Intrinsics.checkNotNullParameter(message, "message");
            Intrinsics.checkNotNullParameter(startPosition, "startPosition");
            Intrinsics.checkNotNullParameter(endPosition, "endPosition");
            this.message = message;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final CodePosition getStartPosition() {
            return this.startPosition;
        }

        @NotNull
        public final CodePosition getEndPosition() {
            return this.endPosition;
        }
    }
}

