/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;

public class NameSuggestion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<DeclarationDescriptor, SuggestedName> cache;

    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        SuggestedName suggestedName;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Map<DeclarationDescriptor, SuggestedName> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        SuggestedName value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getOriginal(...)");
            SuggestedName answer$iv = this.generate(declarationDescriptor, bindingContext);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            suggestedName = value$iv;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        DeclarationDescriptor declarationDescriptor;
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor2);
            return this.suggest(declarationDescriptor2, bindingContext);
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend() && (declarationDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
            DeclarationDescriptor it = declarationDescriptor;
            boolean bl = false;
            return NameSuggestion.generate$suggest(this, bindingContext, it);
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List<String> list = CollectionsKt.listOf(descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor3 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor3);
            return new SuggestedName(list, true, descriptor2, declarationDescriptor3);
        }
        declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    Name name = (Name)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.asString());
                }
                DeclarationDescriptor declarationDescriptor4 = ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor5 = descriptor2;
                boolean bl3 = true;
                List list = (List)destination$iv$iv;
                suggestedName = new SuggestedName(list, bl3, declarationDescriptor5, declarationDescriptor4);
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((FakeCallableDescriptorForObject)descriptor2).getReferencedObject());
        }
        if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "getContainingDeclaration(...)");
                return NameSuggestion.generate$suggest(this, bindingContext, classifierDescriptorWithTypeParameters);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String ownName;
            String string = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, bindingContext);
            if (string == null) {
                string = this.getSuggestedName(descriptor2);
            }
            String name = ownName = string;
            DeclarationDescriptor declarationDescriptor6 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor6, "getContainingDeclaration(...)");
            DeclarationDescriptor scope2 = declarationDescriptor6;
            if (descriptor2 instanceof FunctionDescriptor) {
                DeclarationDescriptor declarationDescriptor7 = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor7, "getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor7;
                String liftedName = ownName;
                boolean hasInline = false;
                while (container instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor)container).isInline() && NameSuggestion.Companion.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)container).isPublicAPI()) {
                        hasInline = true;
                    }
                    liftedName = this.getSuggestedName(container) + '$' + liftedName;
                    Intrinsics.checkNotNullExpressionValue(((FunctionDescriptor)container).getContainingDeclaration(), "getContainingDeclaration(...)");
                }
                if (hasInline) {
                    scope2 = container;
                    name = liftedName;
                }
            }
            return new SuggestedName(CollectionsKt.listOf(name), false, descriptor2, scope2);
        }
        return this.generateDefault(descriptor2, bindingContext);
    }

    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        String string;
        List parts = new ArrayList();
        DeclarationDescriptor current = descriptor2;
        if (current instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)current).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableDescriptor callableDescriptor = NameSuggestion.Companion.getOverridden((CallableDescriptor)current);
            Intrinsics.checkNotNull(callableDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)callableDescriptor;
            if (!ModalityUtilsKt.isOverridableOrOverrides(overridden)) {
                current = overridden;
            }
        }
        DeclarationDescriptor fixedDescriptor = current;
        Collection collection = parts;
        if (fixedDescriptor instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNull(classifierDescriptorWithTypeParameters);
            current = classifierDescriptorWithTypeParameters;
            string = this.getSuggestedName(current) + "_init";
        } else {
            string = this.getSuggestedName(fixedDescriptor);
        }
        Object object = string;
        collection.add(object);
        if (current.getContainingDeclaration() instanceof FunctionDescriptor && !(current instanceof TypeParameterDescriptor)) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            SuggestedName suggestedName = this.suggest((FunctionDescriptor)declarationDescriptor, bindingContext);
            Intrinsics.checkNotNull(suggestedName);
            SuggestedName outerFunctionName = suggestedName;
            ((Collection)parts).add(CollectionsKt.single(outerFunctionName.getNames()));
            current = outerFunctionName.getScope();
        } else {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor);
            current = declarationDescriptor;
        }
        if (current instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            current = declarationDescriptor;
        }
        CollectionsKt.reverse(parts);
        String unmangledName = CollectionsKt.joinToString$default(parts, "$", null, null, 0, null, null, 62, null);
        object = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor, bindingContext);
        String id = ((Companion.NameAndStability)object).component1();
        boolean stable = ((Companion.NameAndStability)object).component2();
        return new SuggestedName(CollectionsKt.listOf(id), stable, fixedDescriptor, current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        String string;
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name name2 = name;
        if (name2.isSpecial()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyGetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("get_");
                PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                string = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("set_");
                PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                string = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else {
                string = "f";
            }
        } else {
            String string2 = name2.asString();
            Intrinsics.checkNotNull(string2);
            string = string2;
        }
        return string;
    }

    private static final SuggestedName generate$suggest(NameSuggestion this$0, BindingContext $bindingContext, DeclarationDescriptor d2) {
        return this$0.suggest(d2, $bindingContext);
    }

    public static final class Companion {
        private Companion() {
        }

        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2, BindingContext bindingContext) {
            DeclarationDescriptor overriddenDescriptor = descriptor2 instanceof CallableDescriptor ? (DeclarationDescriptor)SequencesKt.last(SequencesKt.generateSequence(descriptor2, Companion::mangleNameIfNecessary$lambda$0)) : descriptor2;
            String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor, bindingContext);
            if (nativeName != null) {
                return new NameAndStability(nativeName, true);
            }
            if (overriddenDescriptor instanceof FunctionDescriptor) {
                String string = DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString();
                if (Intrinsics.areEqual(string, "kotlin.CharSequence.get")) {
                    return new NameAndStability("charCodeAt", true);
                }
                if (Intrinsics.areEqual(string, "kotlin.Any.equals")) {
                    return new NameAndStability("equals", true);
                }
                DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)overriddenDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (container instanceof ClassDescriptor) {
                    SimpleType simpleType2 = ((ClassDescriptor)container).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                    if (ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType(simpleType2)) {
                        String name;
                        String string2 = ((FunctionDescriptor)overriddenDescriptor).getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                        String string3 = name = string2;
                        if (Intrinsics.areEqual(string3, "get") || Intrinsics.areEqual(string3, "set")) {
                            return new NameAndStability(name, true);
                        }
                    }
                }
            } else if (overriddenDescriptor instanceof PropertyDescriptor && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString(), "kotlin.reflect.KCallable.name")) {
                return new NameAndStability("callableName", true);
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return SequencesKt.last(SequencesKt.generateSequence(descriptor2, Companion::getOverridden$lambda$1));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            NameAndStability nameAndStability;
            DeclarationDescriptor containingDeclaration;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            DescriptorVisibility effectiveVisibility = this.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)descriptor2);
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            DeclarationDescriptor declarationDescriptor2 = containingDeclaration = declarationDescriptor;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                nameAndStability = effectiveVisibility.isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName));
            } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                nameAndStability = descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.PUBLIC) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (ModalityUtilsKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.PROTECTED) && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledPrivate(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName))))));
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw new AssertionError((Object)string);
                }
                nameAndStability = org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            return nameAndStability;
        }

        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(baseName, "baseName");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            String ownerName = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            return this.getStableMangledName(this.sanitizeName(baseName), ownerName + '.' + baseName + ':' + EncodeSignatureKt.encodeSignature(descriptor2));
        }

        @NotNull
        public final String getInternalMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter(suggestedName, "suggestedName");
            Intrinsics.checkNotNullParameter(forCalculateId, "forCalculateId");
            String suffix = '_' + this.mangledId("internal:" + forCalculateId) + '$';
            return suggestedName + suffix;
        }

        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter(suggestedName, "suggestedName");
            Intrinsics.checkNotNullParameter(forCalculateId, "forCalculateId");
            String suffix = ((CharSequence)forCalculateId).length() == 0 ? "" : '_' + this.mangledId(forCalculateId) + '$';
            return suggestedName + suffix;
        }

        private final String mangledId(String forCalculateId) {
            String string;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string2 = Integer.toString(absHashCode, CharsKt.checkRadix(36));
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            } else {
                string = "";
            }
            return string;
        }

        private final DescriptorVisibility getOwnEffectiveVisibility(DeclarationDescriptorWithVisibility $this$ownEffectiveVisibility) {
            DescriptorVisibility descriptorVisibility = $this$ownEffectiveVisibility.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
            return EffectiveVisibilityUtilsKt.toDescriptorVisibility(EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, $this$ownEffectiveVisibility, true));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String sanitizeName(@NotNull String name) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(name, "name");
            if (((CharSequence)name).length() == 0) {
                return "_";
            }
            char it = StringsKt.first(name);
            boolean $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = false;
            char first2 = IdentifierPolicyKt.isES5IdentifierStart(it) ? it : (char)'_';
            CharSequence charSequence = StringsKt.drop(name, 1);
            StringBuilder stringBuilder = new StringBuilder().append(first2);
            boolean $i$f$map = false;
            void $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i2 = 0; i2 < $this$mapTo$iv$iv.length(); ++i2) {
                char it2;
                char item$iv$iv;
                char c2 = item$iv$iv = $this$mapTo$iv$iv.charAt(i2);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(IdentifierPolicyKt.isES5IdentifierPart(it2) ? it2 : (char)'_'));
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null)).toString();
        }

        private static final CallableDescriptor mangleNameIfNecessary$lambda$0(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final CallableDescriptor getOverridden$lambda$1(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final NameAndStability mangleRegularNameIfNecessary$regularAndUnstable(String $baseName) {
            return new NameAndStability($baseName, false);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledAndStable(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getStableMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledInternal(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getInternalMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledPrivate(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getPrivateMangledName($baseName, (CallableDescriptor)$descriptor), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            public NameAndStability(@NotNull String name, boolean stable) {
                Intrinsics.checkNotNullParameter(name, "name");
                this.name = name;
                this.stable = stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.stable);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NameAndStability)) {
                    return false;
                }
                NameAndStability nameAndStability = (NameAndStability)other;
                if (!Intrinsics.areEqual(this.name, nameAndStability.name)) {
                    return false;
                }
                return this.stable == nameAndStability.stable;
            }
        }
    }
}

