/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;

public final class EncodeSignatureKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String encodeSignature(@NotNull CallableDescriptor descriptor2) {
        ReceiverParameterDescriptor receiverParameter;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        StringBuilder sig = new StringBuilder();
        Map<TypeParameterDescriptor, String> typeParameterNames = EncodeSignatureKt.nameTypeParameters(descriptor2);
        List<TypeParameterDescriptor> list = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!it.isCapturedFromOuterDeclaration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set currentParameters = CollectionsKt.toSet((List)destination$iv$iv);
        Set usedTypeParameters = CollectionsKt.toMutableSet(currentParameters);
        Function1<TypeParameterDescriptor, String> typeParameterNamer = arg_0 -> EncodeSignatureKt.encodeSignature$lambda$1(usedTypeParameters, typeParameterNames, descriptor2, arg_0);
        List<ReceiverParameterDescriptor> list2 = descriptor2.getContextReceiverParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getContextReceiverParameters(...)");
        List<ReceiverParameterDescriptor> contextReceiverParameters = list2;
        if (!((Collection)contextReceiverParameters).isEmpty()) {
            for (ReceiverParameterDescriptor contextReceiverParameter : contextReceiverParameters) {
                KotlinType kotlinType = contextReceiverParameter.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer).append(',');
            }
            sig.append('\\');
        }
        if ((receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer).append('/');
        }
        for (ValueParameterDescriptor valueParameter2 : descriptor2.getValueParameters()) {
            if (valueParameter2.getIndex() > 0) {
                sig.append(",");
            }
            if (valueParameter2.getVarargElementType() != null) {
                sig.append("*");
            }
            KotlinType kotlinType = valueParameter2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer);
        }
        boolean first2 = true;
        Iterator<Object> iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)typeParameterNames.keySet()), arg_0 -> EncodeSignatureKt.encodeSignature$lambda$2(usedTypeParameters, arg_0)).iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv2;
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)iterator2.next();
            List<KotlinType> list3 = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list3, "getUpperBounds(...)");
            Iterable $this$filter$iv2 = list3;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                KotlinType it = (KotlinType)element$iv$iv;
                boolean bl = false;
                if (!(!KotlinBuiltIns.isNullableAny(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List upperBounds2 = (List)destination$iv$iv2;
            if (upperBounds2.isEmpty() && !currentParameters.contains(typeParameter)) continue;
            sig.append(first2 ? "|" : ",").append(typeParameterNames.get(typeParameter));
            first2 = false;
            if (upperBounds2.isEmpty()) continue;
            sig.append("<:");
            Iterator iterator3 = ((Iterable)upperBounds2).iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int boundIndex = n2++;
                KotlinType upperBound = (KotlinType)iterator3.next();
                if (boundIndex > 0) {
                    sig.append("&");
                }
                Intrinsics.checkNotNull(upperBound);
                EncodeSignatureKt.encodeForSignature(sig, upperBound, typeParameterNamer);
            }
        }
        String string = sig.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final StringBuilder encodeForSignature(StringBuilder $this$encodeForSignature, KotlinType type2, Function1<? super TypeParameterDescriptor, String> typeParameterNamer) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull(classifierDescriptor);
        ClassifierDescriptor declaration = classifierDescriptor;
        if (declaration instanceof TypeParameterDescriptor) {
            StringBuilder stringBuilder = $this$encodeForSignature.append(typeParameterNamer.invoke((TypeParameterDescriptor)declaration));
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
            return stringBuilder;
        }
        StringBuilder stringBuilder = FunctionTypesKt.isSuspendFunctionType(type2) ? $this$encodeForSignature.append(StringsKt.replace$default(DescriptorUtils.getFqName(declaration).asString(), "kotlin.coroutines.SuspendFunction", "kotlin.SuspendFunction", false, 4, null)) : $this$encodeForSignature.append(DescriptorUtils.getFqName(declaration).asString());
        List<TypeParameterDescriptor> list = declaration.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list;
        if (!((Collection)type2.getArguments()).isEmpty() && !((Collection)parameters2).isEmpty()) {
            $this$encodeForSignature.append("<");
            for (Pair pair : CollectionsKt.zip((Iterable)type2.getArguments(), (Iterable)parameters2)) {
                TypeProjection argument = (TypeProjection)pair.component1();
                TypeParameterDescriptor parameter = (TypeParameterDescriptor)pair.component2();
                if (parameter.getIndex() > 0) {
                    $this$encodeForSignature.append(",");
                }
                Intrinsics.checkNotNull(parameter);
                EncodeSignatureKt.encodeForSignature($this$encodeForSignature, argument, parameter, typeParameterNamer);
            }
            $this$encodeForSignature.append(">");
        }
        if (type2.isMarkedNullable()) {
            $this$encodeForSignature.append("?");
        }
        return $this$encodeForSignature;
    }

    private static final StringBuilder encodeForSignature(StringBuilder $this$encodeForSignature, TypeProjection projection, TypeParameterDescriptor parameter, Function1<? super TypeParameterDescriptor, String> typeParameterNamer) {
        StringBuilder stringBuilder;
        if (projection.isStarProjection()) {
            StringBuilder stringBuilder2 = $this$encodeForSignature.append("*");
            Intrinsics.checkNotNull(stringBuilder2);
            stringBuilder = stringBuilder2;
        } else {
            Variance variance = parameter.getVariance();
            Intrinsics.checkNotNullExpressionValue((Object)variance, "getVariance(...)");
            Variance variance2 = projection.getProjectionKind();
            Intrinsics.checkNotNullExpressionValue((Object)variance2, "getProjectionKind(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[UtilsKt.getEffectiveVariance(variance, variance2).ordinal()]) {
                case 1: {
                    Object object = $this$encodeForSignature.append("-");
                    break;
                }
                case 2: {
                    Object object = $this$encodeForSignature.append("+");
                    break;
                }
                case 3: {
                    Object object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KotlinType kotlinType = projection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            stringBuilder = EncodeSignatureKt.encodeForSignature($this$encodeForSignature, kotlinType, typeParameterNamer);
        }
        return stringBuilder;
    }

    private static final Map<TypeParameterDescriptor, String> nameTypeParameters(DeclarationDescriptor descriptor2) {
        Map result2 = new LinkedHashMap();
        Iterator iterator2 = ((Iterable)EncodeSignatureKt.collectTypeParameters(descriptor2)).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int listIndex = n2++;
            List list = (List)iterator2.next();
            Iterator iterator3 = ((Iterable)list).iterator();
            int n3 = 0;
            while (iterator3.hasNext()) {
                int indexInList = n3++;
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)iterator3.next();
                result2.put(typeParameter, "" + listIndex + ':' + indexInList);
            }
        }
        return result2;
    }

    private static final List<List<TypeParameterDescriptor>> collectTypeParameters(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor currentDescriptor = descriptor2;
        List result2 = new ArrayList();
        while (currentDescriptor != null) {
            if (EncodeSignatureKt.getOwnTypeParameters(currentDescriptor) != null) {
                List<TypeParameterDescriptor> it;
                boolean bl = false;
                ((Collection)result2).add(it);
            }
            currentDescriptor = currentDescriptor instanceof ConstructorDescriptor ? ((ConstructorDescriptor)currentDescriptor).getConstructedClass().getContainingDeclaration() : currentDescriptor.getContainingDeclaration();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeParameterDescriptor> getOwnTypeParameters(DeclarationDescriptor descriptor2) {
        List list;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            void $this$filterTo$iv$iv;
            List<TypeParameterDescriptor> list2 = ((ClassDescriptor)descriptor2).getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getDeclaredTypeParameters(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!it.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
            list = EncodeSignatureKt.getOwnTypeParameters(propertyDescriptor);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            List<TypeParameterDescriptor> list3 = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "getTypeParameters(...)");
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!it.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private static final String encodeSignature$lambda$1(Set $usedTypeParameters, Map $typeParameterNames, CallableDescriptor $descriptor, TypeParameterDescriptor typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        ((Collection)$usedTypeParameters).add(typeParameter.getOriginal());
        String string = (String)$typeParameterNames.get(typeParameter.getOriginal());
        if (string == null) {
            throw new IllegalStateException((typeParameter.getOriginal() + " is not found when encode the signature of " + $descriptor + '.').toString());
        }
        return string;
    }

    private static final boolean encodeSignature$lambda$2(Set $usedTypeParameters, TypeParameterDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $usedTypeParameters.contains(it);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

