/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.JsYield;

public abstract class JsVisitor {
    public <T extends JsNode> void accept(T node) {
        block0: {
            T t2 = node;
            if (t2 == null) break block0;
            t2.accept(this);
        }
    }

    public final <T extends JsNode> void acceptList(@NotNull List<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        for (JsNode node : collection) {
            this.accept(node);
        }
    }

    public final void acceptLvalue(@NotNull JsExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.accept((JsNode)expression);
    }

    public final <T extends JsNode> void acceptWithInsertRemove(@NotNull List<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        for (JsNode node : collection) {
            this.accept(node);
        }
    }

    public void visitArrayAccess(@NotNull JsArrayAccess x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitArray(@NotNull JsArrayLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitBinaryExpression(@NotNull JsBinaryOperation x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitBlock(@NotNull JsBlock x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitBoolean(@NotNull JsBooleanLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitBreak(@NotNull JsBreak x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitCase(@NotNull JsCase x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitCatch(@NotNull JsCatch x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitClass(@NotNull JsClass x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitConditional(@NotNull JsConditional x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitContinue(@NotNull JsContinue x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitYield(@NotNull JsYield x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitDebugger(@NotNull JsDebugger x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitDefault(@NotNull JsDefault x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitDoWhile(@NotNull JsDoWhile x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitLoop(x2);
    }

    public void visitEmpty(@NotNull JsEmpty x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitExpressionStatement(@NotNull JsExpressionStatement x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitFor(@NotNull JsFor x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitLoop(x2);
    }

    public void visitForIn(@NotNull JsForIn x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitLoop(x2);
    }

    public void visitFunction(@NotNull JsFunction x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitIf(@NotNull JsIf x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        this.visitElement(invocation);
    }

    public void visitLabel(@NotNull JsLabel x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitLoop(@NotNull JsLoop x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        this.visitElement(nameRef);
    }

    public void visitNew(@NotNull JsNew x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitNull(@NotNull JsNullLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitInt(@NotNull JsIntLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitDouble(@NotNull JsDoubleLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitObjectLiteral(@NotNull JsObjectLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitParameter(@NotNull JsParameter x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitPostfixOperation(@NotNull JsPostfixOperation x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitPrefixOperation(@NotNull JsPrefixOperation x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitProgram(@NotNull JsProgram x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitRegExp(@NotNull JsRegExp x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitReturn(@NotNull JsReturn x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitString(@NotNull JsStringLiteral x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visit(@NotNull JsSwitch x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitThis(@NotNull JsThisRef x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitThrow(@NotNull JsThrow x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitTry(@NotNull JsTry x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visit(@NotNull JsVars.JsVar x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitVars(@NotNull JsVars x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitElement(x2);
    }

    public void visitWhile(@NotNull JsWhile x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        this.visitLoop(x2);
    }

    public void visitDocComment(@NotNull JsDocComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    public void visitSingleLineComment(@NotNull JsSingleLineComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    public void visitMultiLineComment(@NotNull JsMultiLineComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
    }
}

