/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;

public final class JsLocation
implements JsLocationWithSource {
    @NotNull
    private final String file;
    private final int startLine;
    private final int startChar;
    @Nullable
    private final String name;

    public JsLocation(@NotNull String file, int startLine, int startChar, @Nullable String name) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
        this.startLine = startLine;
        this.startChar = startChar;
        this.name = name;
    }

    @NotNull
    public String toString() {
        return "JsLocation(file=" + this.file + ", startLine=" + this.startLine + ", startChar=" + this.startChar + ", name=" + this.name + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.startLine);
        result2 = result2 * 31 + Integer.hashCode(this.startChar);
        result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsLocation)) {
            return false;
        }
        JsLocation jsLocation = (JsLocation)other;
        if (!Intrinsics.areEqual(this.file, jsLocation.file)) {
            return false;
        }
        if (this.startLine != jsLocation.startLine) {
            return false;
        }
        if (this.startChar != jsLocation.startChar) {
            return false;
        }
        return Intrinsics.areEqual(this.name, jsLocation.name);
    }
}

