/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

public class JsDeclarationScope
extends JsScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrayList<LabelScope> labelScopesImpl;
    @NotNull
    private static final Set<String> RESERVED_WORDS;

    public JsDeclarationScope(@NotNull JsScope parent2, @NotNull String description2, boolean useParentScopeStack) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(description2, "description");
        super(parent2, description2);
        this.labelScopesImpl = parent2 instanceof JsDeclarationScope && useParentScopeStack ? ((JsDeclarationScope)parent2).labelScopesImpl : null;
    }

    public /* synthetic */ JsDeclarationScope(JsScope jsScope, String string, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(jsScope, string, bl);
    }

    private final LabelScope getTopLabelScope() {
        LabelScope labelScope;
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList != null) {
            ArrayList<LabelScope> it = arrayList;
            boolean bl = false;
            labelScope = !((Collection)it).isEmpty() ? (LabelScope)CollectionsKt.last((List)it) : null;
        } else {
            labelScope = null;
        }
        return labelScope;
    }

    private final ArrayList<LabelScope> getLabelScopes() {
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList == null) {
            ArrayList arrayList2;
            ArrayList it = arrayList2 = new ArrayList();
            boolean bl = false;
            this.labelScopesImpl = it;
            arrayList = arrayList2;
        }
        return arrayList;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label, @NotNull String outputName) {
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(outputName, "outputName");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label, outputName);
        this.getLabelScopes().add(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        boolean bl;
        ArrayList<LabelScope> it = this.getLabelScopes();
        boolean bl2 = false;
        boolean bl3 = bl = !((Collection)it).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "No scope to exit from";
            throw new AssertionError((Object)string);
        }
        LabelScope cfr_ignored_0 = (LabelScope)CollectionsKt.removeLast((List)it);
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter(label, "label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    static {
        String[] stringArray = new String[]{"NaN", "isNaN", "Infinity", "undefined", "Error", "Object", "Math", "String", "Number", "Boolean", "Date", "Array", "RegExp", "JSON", "require", "define", "module", "window", "self", "Kotlin"};
        RESERVED_WORDS = SetsKt.plus(IdentifierPolicyKt.getRESERVED_KEYWORDS(), (Iterable)SetsKt.setOf(stringArray));
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private final class LabelScope
    extends JsScope {
        @NotNull
        private final String ident;
        @NotNull
        private final JsName labelName;

        public LabelScope(@NotNull LabelScope parent2, @NotNull String ident, String outputIdent) {
            Intrinsics.checkNotNullParameter(ident, "ident");
            Intrinsics.checkNotNullParameter(outputIdent, "outputIdent");
            super(parent2, "Label scope for " + ident);
            this.ident = ident;
            this.labelName = new JsName(outputIdent, true);
        }

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return Intrinsics.areEqual(name, this.ident) ? this.labelName : null;
        }
    }
}

