/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\u0011H\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtCollectionLiteralReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;)V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getRanges", "", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "normalizeRange", "Lcom/intellij/psi/PsiElement;", "Companion", "kt-references"})
public abstract class KtCollectionLiteralReference
extends KtSimpleReference<KtCollectionLiteralExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> COLLECTION_LITERAL_CALL_NAMES = CollectionsKt.plus(ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().values(), ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION());

    public KtCollectionLiteralReference(@NotNull KtCollectionLiteralExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        super((KtReferenceExpression)expression);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        Object t2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue(t2, "getElement(...)");
        return this.normalizeRange((PsiElement)t2);
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        TextRange[] textRangeArray = new TextRange[2];
        PsiElement psiElement = ((KtCollectionLiteralExpression)this.getElement()).getLeftBracket();
        textRangeArray[0] = psiElement != null ? this.normalizeRange(psiElement) : null;
        PsiElement psiElement2 = ((KtCollectionLiteralExpression)this.getElement()).getRightBracket();
        textRangeArray[1] = psiElement2 != null ? this.normalizeRange(psiElement2) : null;
        return CollectionsKt.listOfNotNull(textRangeArray);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return COLLECTION_LITERAL_CALL_NAMES;
    }

    private final TextRange normalizeRange(PsiElement $this$normalizeRange) {
        TextRange textRange = $this$normalizeRange.getTextRange().shiftRight(-((KtCollectionLiteralExpression)this.getExpression()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "shiftRight(...)");
        return textRange;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtCollectionLiteralReference$Companion;", "", "<init>", "()V", "COLLECTION_LITERAL_CALL_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kt-references"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

