/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCommonFile;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B-\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\u0004\b\u0006\u0010\u000eB'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\u0004\b\u0006\u0010\u000fJ$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u0016H\u0007J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"J\u001a\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "languageVersionSettingsProvider", "Lkotlin/Function0;", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lkotlin/jvm/functions/Function1;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings$delegate", "Lkotlin/Lazy;", "getFunctionDescriptor", "isMain", "", "function", "checkJvmStaticAnnotation", "allowParameterless", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkReturnType", "isMainWithParameter", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMainFunction", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "isParameterNumberSuitsForMain", "parametersCount", "", "isTopLevel", "Companion", "Factory", "frontend"})
public final class MainFunctionDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy languageVersionSettings$delegate;
    @NotNull
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    @NotNull
    private final Function0<LanguageVersionSettings> getLanguageVersionSettings;

    private final LanguageVersionSettings getLanguageVersionSettings() {
        Lazy lazy = this.languageVersionSettings$delegate;
        return (LanguageVersionSettings)lazy.getValue();
    }

    public MainFunctionDetector(@NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings$delegate = LazyKt.lazy(() -> MainFunctionDetector.languageVersionSettings_delegate$lambda$0(this));
        this.getFunctionDescriptor = arg_0 -> MainFunctionDetector._init_$lambda$1(bindingContext, arg_0);
        this.getLanguageVersionSettings = () -> MainFunctionDetector._init_$lambda$2(languageVersionSettings);
    }

    public MainFunctionDetector(@NotNull Function0<? extends LanguageVersionSettings> languageVersionSettingsProvider, @NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkNotNullParameter(languageVersionSettingsProvider, "languageVersionSettingsProvider");
        Intrinsics.checkNotNullParameter(functionResolver, "functionResolver");
        this.languageVersionSettings$delegate = LazyKt.lazy(() -> MainFunctionDetector.languageVersionSettings_delegate$lambda$0(this));
        this.getLanguageVersionSettings = languageVersionSettingsProvider;
        this.getFunctionDescriptor = functionResolver;
    }

    public MainFunctionDetector(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(functionResolver, "functionResolver");
        this(() -> MainFunctionDetector._init_$lambda$3(languageVersionSettings), functionResolver);
    }

    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation, boolean allowParameterless) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel(), allowParameterless)) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!Intrinsics.areEqual("main", function2.getName()) && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (checkJvmStaticAnnotation && !function2.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = this.getFunctionDescriptor.invoke(function2);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return MainFunctionDetector.isMain$default(this, functionDescriptor2, checkJvmStaticAnnotation, false, allowParameterless, 4, null);
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, KtNamedFunction ktNamedFunction, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        return mainFunctionDetector.isMain(ktNamedFunction, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType, boolean allowParameterless) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(MainFunctionDetector.Companion.getJVMFunctionName((FunctionDescriptor)descriptor2), "main")) {
            return false;
        }
        List<ValueParameterDescriptor> list = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable iterable = list;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            void var14_23 = destination$iv;
            boolean bl = false;
            var14_23.add(it.getType());
        }
        List parameters2 = (List)destination$iv;
        Annotated annotated = ((FunctionDescriptor)descriptor2).getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            Annotated it = annotated;
            boolean bl = false;
            ((Collection)parameters2).add(it);
        }
        if (!this.isParameterNumberSuitsForMain(parameters2.size(), DescriptorUtils.isTopLevelDeclaration(descriptor2), allowParameterless)) {
            return false;
        }
        List<TypeParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        if (!((Collection)list2).isEmpty()) {
            return false;
        }
        if (parameters2.size() == 1) {
            KotlinType parameterType = (KotlinType)parameters2.get(0);
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> typeArguments = parameterType.getArguments();
            if (typeArguments.size() != 1) {
                return false;
            }
            KotlinType kotlinType = typeArguments.get(0).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            KotlinType typeArgument = kotlinType;
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (typeArguments.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
        } else {
            boolean bl;
            boolean parameterType;
            boolean bl2 = parameterType = parameters2.size() == 0;
            if (_Assertions.ENABLED && !parameterType) {
                boolean $i$a$-assert-MainFunctionDetector$isMain$42 = false;
                String $i$a$-assert-MainFunctionDetector$isMain$42 = "Parameter list is expected to be empty";
                throw new AssertionError((Object)$i$a$-assert-MainFunctionDetector$isMain$42);
            }
            parameterType = DescriptorUtils.isTopLevelDeclaration(descriptor2);
            if (_Assertions.ENABLED && !parameterType) {
                boolean bl3 = false;
                String string = "main without parameters works only for top-level";
                throw new AssertionError((Object)string);
            }
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            if (!Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getName().asString(), "main")) {
                return false;
            }
            Object object = containingFile;
            if (object != null && (object = ((KtCommonFile)object).getDeclarations()) != null) {
                boolean bl4;
                block24: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration declaration = (KtDeclaration)element$iv;
                            boolean bl5 = false;
                            if (!this.isMainWithParameter(declaration, checkJvmStaticAnnotation)) continue;
                            bl4 = true;
                            break block24;
                        }
                        bl4 = false;
                    }
                }
                bl = bl4;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        if (((FunctionDescriptor)descriptor2).isSuspend() && !this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExtendedMainConvention)) {
            return false;
        }
        if (checkReturnType && !MainFunctionDetector.Companion.isMainReturnType((FunctionDescriptor)descriptor2)) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) || !checkJvmStaticAnnotation);
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        return mainFunctionDetector.isMain(declarationDescriptor, bl, bl2, bl3);
    }

    private final boolean isMainWithParameter(KtDeclaration declaration, boolean checkJvmStaticAnnotation) {
        return declaration instanceof KtNamedFunction && this.isMain((KtNamedFunction)declaration, checkJvmStaticAnnotation, false);
    }

    @Nullable
    public final FunctionDescriptor getMainFunction(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        return this.getMainFunction(module2, module2.getPackage(FqName.ROOT));
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor getMainFunction(ModuleDescriptor module2, PackageViewDescriptor packageView) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = packageView.getFragments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(DescriptorUtilsKt.getModule(it), module2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PackageFragmentDescriptor packageFragment : (List)destination$iv$iv) {
            FunctionDescriptor functionDescriptor;
            Object v1;
            block5: {
                void $this$firstOrNull$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(packageFragment.getMemberScope());
                Intrinsics.checkNotNullExpressionValue(collection, "getAllDescriptors(...)");
                $this$filterTo$iv$iv = collection;
                boolean $i$f$filterIsInstance = false;
                void $i$f$filterTo2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator it = $this$filterIsInstanceTo$iv$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    Object element$iv = $this$filterIsInstanceTo$iv$iv.next();
                    FunctionDescriptor it2 = (FunctionDescriptor)element$iv;
                    boolean bl = false;
                    if (!MainFunctionDetector.isMain$default(this, it2, false, false, false, 14, null)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((functionDescriptor = (FunctionDescriptor)v1) == null) continue;
            FunctionDescriptor it = functionDescriptor;
            boolean bl = false;
            return it;
        }
        for (FqName subpackageName : module2.getSubPackagesOf(packageView.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            FunctionDescriptor functionDescriptor = this.getMainFunction(module2, module2.getPackage(subpackageName));
            if (functionDescriptor == null) continue;
            FunctionDescriptor it = functionDescriptor;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel, boolean allowParameterless) {
        boolean bl;
        switch (parametersCount) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                if (isTopLevel && allowParameterless && this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return MainFunctionDetector.isMain$default(this, function2, checkJvmStaticAnnotation, false, 4, null);
    }

    public final boolean isMain(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return MainFunctionDetector.isMain$default(this, function2, false, false, 6, null);
    }

    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, checkReturnType, false, 8, null);
    }

    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, false, false, 12, null);
    }

    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, false, false, false, 14, null);
    }

    private static final LanguageVersionSettings languageVersionSettings_delegate$lambda$0(MainFunctionDetector this$0) {
        return this$0.getLanguageVersionSettings.invoke();
    }

    private static final SimpleFunctionDescriptor _init_$lambda$1(BindingContext $bindingContext, KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)$bindingContext.get(BindingContext.FUNCTION, function2);
        if (simpleFunctionDescriptor == null) {
            throw new KotlinExceptionWithAttachments("No descriptor resolved for " + function2).withPsiAttachment("function.text", function2);
        }
        return simpleFunctionDescriptor;
    }

    private static final LanguageVersionSettings _init_$lambda$2(LanguageVersionSettings $languageVersionSettings) {
        return $languageVersionSettings;
    }

    private static final LanguageVersionSettings _init_$lambda$3(LanguageVersionSettings $languageVersionSettings) {
        return $languageVersionSettings;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "<init>", "()V", "isMainReturnType", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getJVMFunctionName", "", "functionDescriptor", "hasAnnotationWithExactNumberOfArguments", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isMainReturnType(FunctionDescriptor descriptor2) {
            KotlinType returnType = descriptor2.getReturnType();
            return returnType != null && KotlinBuiltIns.isUnit(returnType);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
            String string = DescriptorUtils.getJvmName(functionDescriptor);
            if (string == null) {
                String string2 = functionDescriptor.getName().asString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            }
            return string;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number) {
            boolean bl;
            block3: {
                List<KtAnnotationEntry> list = function2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        if (!(it.getValueArguments().size() == number)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "", "createMainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Ordinary", "frontend"})
    public static interface Factory {
        @NotNull
        public MainFunctionDetector createMainFunctionDetector(@NotNull BindingTrace var1, @NotNull LanguageVersionSettings var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory$Ordinary;", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "<init>", "()V", "createMainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
        public static final class Ordinary
        implements Factory {
            @Override
            @NotNull
            public MainFunctionDetector createMainFunctionDetector(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
                Intrinsics.checkNotNullParameter(trace, "trace");
                Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                return new MainFunctionDetector(bindingContext, languageVersionSettings);
            }
        }
    }
}

