/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeExtensions;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantTypeImpl;", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;", "value", "", "possibleTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isUnsigned", "", "isMarkedNullable", "<init>", "(JLjava/util/Collection;ZZ)V", "getPossibleTypes", "()Ljava/util/Collection;", "supertypes", "", "getSupertypes", "()Ljava/util/List;", "supertypes$delegate", "Lkotlin/Lazy;", "getApproximatedType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Companion", "tree"})
public final class ConeIntegerLiteralConstantTypeImpl
extends ConeIntegerLiteralConstantType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<ConeClassLikeType> possibleTypes;
    @NotNull
    private final Lazy supertypes$delegate;
    @NotNull
    private static final LongRange INT_RANGE = new LongRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
    @NotNull
    private static final LongRange BYTE_RANGE = new LongRange(-128L, 127L);
    @NotNull
    private static final LongRange SHORT_RANGE = new LongRange(-32768L, 32767L);
    @NotNull
    private static final LongRange UBYTE_RANGE = new LongRange(0L & 0xFFL, (long)-1 & 0xFFL);
    @NotNull
    private static final LongRange USHORT_RANGE = new LongRange(0L & 0xFFFFL, (long)-1 & 0xFFFFL);
    @NotNull
    private static final LongRange UINT_RANGE = new LongRange(0L & 0xFFFFFFFFL, (long)-1 & 0xFFFFFFFFL);

    public ConeIntegerLiteralConstantTypeImpl(long value2, @NotNull Collection<? extends ConeClassLikeType> possibleTypes, boolean isUnsigned, boolean isMarkedNullable) {
        Intrinsics.checkNotNullParameter(possibleTypes, "possibleTypes");
        super(value2, isUnsigned, isMarkedNullable);
        this.possibleTypes = possibleTypes;
        this.supertypes$delegate = LazyKt.lazy(() -> ConeIntegerLiteralConstantTypeImpl.supertypes_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Collection<ConeClassLikeType> getPossibleTypes() {
        return this.possibleTypes;
    }

    @Override
    @NotNull
    public List<ConeClassLikeType> getSupertypes() {
        Lazy lazy = this.supertypes$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public ConeClassLikeType getApproximatedType(@Nullable ConeKotlinType expectedType) {
        return ConeIntegerLiteralTypeExtensions.INSTANCE.getApproximatedTypeImpl(this, expectedType);
    }

    private static final List supertypes_delegate$lambda$0(ConeIntegerLiteralConstantTypeImpl this$0) {
        return ConeIntegerLiteralTypeExtensions.INSTANCE.createSupertypeList(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantTypeImpl$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "value", "", "isUnsigned", "", "isTypePresent", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "INT_RANGE", "Lkotlin/ranges/LongRange;", "BYTE_RANGE", "SHORT_RANGE", "UBYTE_RANGE", "USHORT_RANGE", "UINT_RANGE", "tree"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConeSimpleKotlinType create(long value2, boolean isUnsigned, @NotNull Function1<? super ConeClassLikeType, Boolean> isTypePresent) {
            ConeSimpleKotlinType coneSimpleKotlinType;
            Intrinsics.checkNotNullParameter(isTypePresent, "isTypePresent");
            List possibleTypes = new ArrayList();
            if (isUnsigned) {
                boolean bl;
                block10: {
                    org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$addUnsignedPossibleType(possibleTypes, value2);
                    Iterable $this$any$iv = possibleTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ConeClassLikeType it = (ConeClassLikeType)element$iv;
                            boolean bl2 = false;
                            if (!(isTypePresent.invoke(it) == false)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return new ConeErrorType(new ConeSimpleDiagnostic("Unsigned integers need stdlib", DiagnosticKind.UnsignedNumbersAreNotPresent), false, null, null, null, null, null, 126, null);
                }
            } else {
                org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$addSignedPossibleTypes(possibleTypes, value2);
            }
            if (possibleTypes.size() == 1) {
                ConeClassLikeType coneClassLikeType;
                ConeClassLikeType it = coneClassLikeType = ConeIntegerLiteralTypeExtensions.INSTANCE.withNullabilityAndAttributes((ConeClassLikeType)CollectionsKt.single(possibleTypes), false, ConeAttributes.Companion.getEmpty());
                boolean bl = false;
                if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                    boolean bl3;
                    boolean bl4 = bl3 = PrimitivesKt.isLong(it) || PrimitivesKt.isULong(it);
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                }
                coneSimpleKotlinType = coneClassLikeType;
            } else {
                coneSimpleKotlinType = new ConeIntegerLiteralConstantTypeImpl(value2, possibleTypes, isUnsigned, false);
            }
            return coneSimpleKotlinType;
        }

        private final ConeClassLikeType createType(ClassId classId) {
            return new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(classId), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null);
        }

        private static final void create$checkBoundsAndAddPossibleType(long $value, List<ConeClassLikeType> possibleTypes, ClassId classId, LongRange range) {
            long l2 = range.getFirst();
            boolean bl = $value <= range.getLast() ? l2 <= $value : false;
            if (bl) {
                possibleTypes.add(Companion.createType(classId));
            }
        }

        private static final void create$addSignedPossibleTypes(List<ConeClassLikeType> possibleTypes, long $value) {
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getInt(), INT_RANGE);
            ((Collection)possibleTypes).add(Companion.createType(StandardClassIds.INSTANCE.getLong()));
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getByte(), BYTE_RANGE);
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getShort(), SHORT_RANGE);
        }

        private static final void create$addUnsignedPossibleType(List<ConeClassLikeType> possibleTypes, long $value) {
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getUInt(), UINT_RANGE);
            ((Collection)possibleTypes).add(Companion.createType(StandardClassIds.INSTANCE.getULong()));
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getUByte(), UBYTE_RANGE);
            org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl$Companion.create$checkBoundsAndAddPossibleType($value, possibleTypes, StandardClassIds.INSTANCE.getUShort(), USHORT_RANGE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

