/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u001c\u0010\u001c\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001b0\u001dH\u0016J$\u0010 \u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b0!H\u0016J(\u0010#\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030$\u0012\u0004\u0012\u00020\u001b0!H\u0016J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0005H'R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractStarImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;ZLjava/util/Set;)V", "getExcludedImportNames", "()Ljava/util/Set;", "starImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStarImports", "()Ljava/util/List;", "isExcluded", "import", "name", "Lorg/jetbrains/kotlin/name/Name;", "absentClassifierNames", "", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "withReplacedSessionOrNull", "newSession", "newScopeSession", "providers"})
public abstract class FirAbstractStarImportingScope
extends FirAbstractImportingScope {
    @NotNull
    private final Set<FqName> excludedImportNames;
    @NotNull
    private final Set<Name> absentClassifierNames;

    public FirAbstractStarImportingScope(@NotNull FirSession session, @NotNull ScopeSession scopeSession, boolean lookupInFir, @NotNull Set<FqName> excludedImportNames) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(excludedImportNames, "excludedImportNames");
        super(session, scopeSession, lookupInFir);
        this.excludedImportNames = excludedImportNames;
        this.absentClassifierNames = new LinkedHashSet();
    }

    @NotNull
    public final Set<FqName> getExcludedImportNames() {
        return this.excludedImportNames;
    }

    @NotNull
    public abstract List<FirResolvedImport> getStarImports();

    @Override
    protected boolean isExcluded(@NotNull FirResolvedImport firResolvedImport, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(firResolvedImport, "import");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!((Collection)this.excludedImportNames).isEmpty()) {
            FqName fqName2 = firResolvedImport.getImportedFqName();
            Intrinsics.checkNotNull(fqName2);
            return this.excludedImportNames.contains(fqName2.child(name));
        }
        return false;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        block6: {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(processor, "processor");
                    if (name.isSpecial()) break block4;
                    String string = name.getIdentifier();
                    Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
                    if (((CharSequence)string).length() == 0) break block5;
                }
                if (!this.getStarImports().isEmpty() && !this.absentClassifierNames.contains(name)) break block6;
            }
            return;
        }
        Ref.BooleanRef foundAny = new Ref.BooleanRef();
        this.processClassifiersFromImportsByName(name, this.getStarImports(), arg_0 -> FirAbstractStarImportingScope.processClassifiersByNameWithSubstitution$lambda$0(foundAny, processor, arg_0));
        if (!foundAny.element) {
            ((Collection)this.absentClassifierNames).add(name);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.processFunctionsByName(name, this.getStarImports(), processor);
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.processPropertiesByName(name, this.getStarImports(), processor);
    }

    @Override
    @NotNull
    public abstract FirAbstractStarImportingScope withReplacedSessionOrNull(@NotNull FirSession var1, @NotNull ScopeSession var2);

    private static final Unit processClassifiersByNameWithSubstitution$lambda$0(Ref.BooleanRef $foundAny, Function2 $processor, FirClassLikeSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        $foundAny.element = true;
        $processor.invoke(symbol, ConeSubstitutor.Empty.INSTANCE);
        return Unit.INSTANCE;
    }
}

