/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.tower.InvokeResolvePriority;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroupKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0000H\u0002J\u0011\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010 \u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "", "code", "", "debugKinds", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "invokeResolvePriority", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;", "receiverGroup", "<init>", "(J[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;)V", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "kindOf", "kind", "Member", "getMember", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "InvokeExtensionWithImplicitReceiver", "getInvokeExtensionWithImplicitReceiver", "Local", "depth", "", "Implicit", "NonLocal", "ContextReceiverGroup", "TopPrioritized", "InvokeReceiver", "InvokeResolvePriority", "debugCompareTo", "other", "compareTo", "equals", "", "", "toString", "", "hashCode", "Companion", "resolve"})
public final class TowerGroup
implements Comparable<TowerGroup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long code;
    @NotNull
    private final TowerGroupKind[] debugKinds;
    @NotNull
    private final InvokeResolvePriority invokeResolvePriority;
    @Nullable
    private final TowerGroup receiverGroup;
    private static final int KIND_SIZE_BITS = Integer.bitCount(15);
    private static final int DEPTH_SIZE_BITS = Integer.bitCount(65535);
    private static final int USABLE_BITS = Long.numberOfLeadingZeros(63L);
    @NotNull
    private static final TowerGroupKind[] EMPTY_KIND_ARRAY = new TowerGroupKind[0];
    @NotNull
    private static final Comparator<TowerGroupKind[]> DEBUG_KINDS_COMPARATOR = (arg_0, arg_1) -> Companion.access$compareDebugKinds(Companion, arg_0, arg_1);
    @NotNull
    private static final TowerGroup EmptyRoot = new TowerGroup(0L, EMPTY_KIND_ARRAY, null, null, 12, null);
    @NotNull
    private static final TowerGroup EmptyRootForInvokeReceiver = new TowerGroup(0L, EMPTY_KIND_ARRAY, InvokeResolvePriority.INVOKE_RECEIVER, null, 8, null);
    @NotNull
    private static final TowerGroup Start = org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup$Companion.access$kindOf(Companion, TowerGroupKind.Start.INSTANCE);
    @NotNull
    private static final TowerGroup QualifierOrClassifier = org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup$Companion.access$kindOf(Companion, TowerGroupKind.QualifierOrClassifier.INSTANCE);
    @NotNull
    private static final TowerGroup QualifierValue = org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup$Companion.access$kindOf(Companion, TowerGroupKind.QualifierValue.INSTANCE);
    @NotNull
    private static final TowerGroup Member = org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup$Companion.access$kindOf(Companion, TowerGroupKind.Member.INSTANCE);
    @NotNull
    private static final TowerGroup Last = org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup$Companion.access$kindOf(Companion, TowerGroupKind.Last.INSTANCE);

    private TowerGroup(long code, TowerGroupKind[] debugKinds, InvokeResolvePriority invokeResolvePriority, TowerGroup receiverGroup) {
        this.code = code;
        this.debugKinds = debugKinds;
        this.invokeResolvePriority = invokeResolvePriority;
        this.receiverGroup = receiverGroup;
    }

    /* synthetic */ TowerGroup(long l2, TowerGroupKind[] towerGroupKindArray, InvokeResolvePriority invokeResolvePriority, TowerGroup towerGroup, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            invokeResolvePriority = InvokeResolvePriority.NONE;
        }
        if ((n2 & 8) != 0) {
            towerGroup = null;
        }
        this(l2, towerGroupKindArray, invokeResolvePriority, towerGroup);
    }

    private final TowerGroup kindOf(TowerGroupKind kind) {
        return new TowerGroup(TowerGroup.Companion.subscript(this.code, kind), TowerGroup.Companion.appendDebugKind(this.debugKinds, kind), null, null, 12, null);
    }

    @NotNull
    public final TowerGroup getMember() {
        return this.kindOf(TowerGroupKind.Member.INSTANCE);
    }

    @NotNull
    public final TowerGroup getInvokeExtensionWithImplicitReceiver() {
        return this.kindOf(TowerGroupKind.InvokeExtensionWithImplicitReceiver.INSTANCE);
    }

    @NotNull
    public final TowerGroup Local(int depth) {
        return this.kindOf(new TowerGroupKind.Local(depth));
    }

    @NotNull
    public final TowerGroup Implicit(int depth) {
        return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
    }

    @NotNull
    public final TowerGroup NonLocal(int depth) {
        return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
    }

    @NotNull
    public final TowerGroup ContextReceiverGroup(int depth) {
        return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth));
    }

    @NotNull
    public final TowerGroup TopPrioritized(int depth) {
        return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
    }

    @NotNull
    public final TowerGroup InvokeReceiver(@NotNull TowerGroup receiverGroup, @NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter(receiverGroup, "receiverGroup");
        Intrinsics.checkNotNullParameter((Object)invokeResolvePriority, "invokeResolvePriority");
        if (!(receiverGroup.invokeResolvePriority == InvokeResolvePriority.INVOKE_RECEIVER)) {
            boolean $i$a$-require-TowerGroup$InvokeReceiver$42 = false;
            String $i$a$-require-TowerGroup$InvokeReceiver$42 = "Receivers for invoke should be resolved with INVOKE_RECEIVER, but " + (Object)((Object)receiverGroup.invokeResolvePriority) + " found";
            throw new IllegalArgumentException($i$a$-require-TowerGroup$InvokeReceiver$42.toString());
        }
        if (!(invokeResolvePriority != InvokeResolvePriority.NONE && invokeResolvePriority != InvokeResolvePriority.INVOKE_RECEIVER)) {
            boolean $i$a$-require-TowerGroup$InvokeReceiver$52 = false;
            String $i$a$-require-TowerGroup$InvokeReceiver$52 = "invokeResolvePriority should be non-trivial when receiverGroup is specified";
            throw new IllegalArgumentException($i$a$-require-TowerGroup$InvokeReceiver$52.toString());
        }
        if (!(receiverGroup.receiverGroup == null)) {
            boolean bl = false;
            String string = "receiverGroup should be trivial, but " + receiverGroup.receiverGroup + " was found";
            throw new IllegalArgumentException(string.toString());
        }
        return new TowerGroup(this.code, this.debugKinds, invokeResolvePriority, receiverGroup);
    }

    @NotNull
    public final TowerGroup InvokeResolvePriority(@NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter((Object)invokeResolvePriority, "invokeResolvePriority");
        if (invokeResolvePriority == InvokeResolvePriority.NONE) {
            return this;
        }
        return new TowerGroup(this.code, this.debugKinds, invokeResolvePriority, null, 8, null);
    }

    @Override
    public int compareTo(@NotNull TowerGroup other) {
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter(other, "other");
        TowerGroup $this$compareTo_u24lambda_u243 = this;
        boolean bl = false;
        if ($this$compareTo_u24lambda_u243.receiverGroup == null && other.receiverGroup == null && $this$compareTo_u24lambda_u243.invokeResolvePriority == InvokeResolvePriority.NONE && other.invokeResolvePriority == InvokeResolvePriority.NONE) {
            n3 = Long.compareUnsigned($this$compareTo_u24lambda_u243.code, other.code);
        } else {
            long otherMax;
            TowerGroup towerGroup = $this$compareTo_u24lambda_u243.receiverGroup;
            long receiverCode = towerGroup != null ? towerGroup.code : 0L;
            TowerGroup towerGroup2 = other.receiverGroup;
            long otherReceiverCode = towerGroup2 != null ? towerGroup2.code : 0L;
            long thisMax = Long.compareUnsigned($this$compareTo_u24lambda_u243.code, receiverCode) >= 0 ? $this$compareTo_u24lambda_u243.code : receiverCode;
            int resultMax = Long.compareUnsigned(thisMax, otherMax = Long.compareUnsigned(other.code, otherReceiverCode) >= 0 ? other.code : otherReceiverCode);
            if (resultMax != 0) {
                n3 = resultMax;
            } else {
                int invokeKindPriority = $this$compareTo_u24lambda_u243.invokeResolvePriority.compareTo((Enum)other.invokeResolvePriority);
                if (invokeKindPriority != 0) {
                    return invokeKindPriority;
                }
                return Long.compareUnsigned(receiverCode, thisMax) == 0 && Long.compareUnsigned(otherReceiverCode, thisMax) == 0 ? Long.compareUnsigned($this$compareTo_u24lambda_u243.code, other.code) : Long.compareUnsigned(receiverCode, otherReceiverCode);
            }
        }
        int it = n2 = n3;
        boolean bl2 = false;
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup");
        TowerGroup cfr_ignored_0 = (TowerGroup)other;
        if (this.code != ((TowerGroup)other).code) {
            return false;
        }
        if (this.invokeResolvePriority != ((TowerGroup)other).invokeResolvePriority) {
            return false;
        }
        return this.receiverGroup == null || ((TowerGroup)other).receiverGroup == null || Intrinsics.areEqual(this.receiverGroup, ((TowerGroup)other).receiverGroup);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("TowerGroup(code=").append(Long.toBinaryString(this.code)).append(", debugKinds=");
        String string = Arrays.toString(this.debugKinds);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return stringBuilder.append(string).append(", invokeResolvePriority=").append((Object)this.invokeResolvePriority).append(')').toString();
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.code);
        result2 = 31 * result2 + this.invokeResolvePriority.hashCode();
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J)\u0010\u001b\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u000e\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005J\u000e\u00106\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005J\u000e\u00107\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005J\u000e\u00108\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\u001f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0 j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010&\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010(R\u0011\u0010-\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010(R\u0011\u0010/\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010(R\u0011\u00101\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010(R\u0011\u00109\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010(\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup$Companion;", "", "<init>", "()V", "KIND_MASK", "", "KIND_SIZE_BITS", "DEPTH_MASK", "DEPTH_SIZE_BITS", "USED_BITS_MASK", "", "TOTAL_BITS", "USABLE_BITS", "EMPTY_KIND_ARRAY", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "DEBUG", "", "appendDebugKind", "kinds", "kind", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "debugKindArrayOf", "(Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "subscript", "code", "compareDebugKinds", "aDebugKinds", "bDebugKinds", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)I", "DEBUG_KINDS_COMPARATOR", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getDEBUG_KINDS_COMPARATOR", "()Ljava/util/Comparator;", "kindOf", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "EmptyRoot", "getEmptyRoot", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "EmptyRootForInvokeReceiver", "getEmptyRootForInvokeReceiver", "Start", "getStart", "QualifierOrClassifier", "getQualifierOrClassifier", "QualifierValue", "getQualifierValue", "Member", "getMember", "Local", "depth", "Implicit", "NonLocal", "ContextReceiverGroup", "TopPrioritized", "Last", "getLast", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        private final TowerGroupKind[] appendDebugKind(TowerGroupKind[] kinds2, TowerGroupKind kind) {
            return EMPTY_KIND_ARRAY;
        }

        private final TowerGroupKind[] debugKindArrayOf(TowerGroupKind kind) {
            return EMPTY_KIND_ARRAY;
        }

        private final long subscript(long code, TowerGroupKind kind) {
            long l2;
            int usedBits = (int)(code & 0x3FL);
            if (kind instanceof TowerGroupKind.WithDepth) {
                int kindUsedBits = usedBits + KIND_SIZE_BITS;
                int depthUsedBits = kindUsedBits + DEPTH_SIZE_BITS;
                if (!(((TowerGroupKind.WithDepth)kind).getDepth() <= 65535)) {
                    boolean $i$a$-require-TowerGroup$Companion$subscript$32 = false;
                    String $i$a$-require-TowerGroup$Companion$subscript$32 = "Depth overflow: requested: " + ((TowerGroupKind.WithDepth)kind).getDepth() + ", allowed: 65535";
                    throw new IllegalArgumentException($i$a$-require-TowerGroup$Companion$subscript$32.toString());
                }
                if (!(depthUsedBits <= USABLE_BITS)) {
                    boolean bl = false;
                    String string = "BitGroup overflow: newUsedBits: " + depthUsedBits + ", original: " + Long.toBinaryString(code) + ", usedBits: " + usedBits;
                    throw new IllegalArgumentException(string.toString());
                }
                l2 = code | (long)kind.getIndex() << 64 - kindUsedBits | (long)((TowerGroupKind.WithDepth)kind).getDepth() << 64 - depthUsedBits | (long)depthUsedBits;
            } else {
                int newUsedBits = usedBits + KIND_SIZE_BITS;
                if (!(newUsedBits <= USABLE_BITS)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                l2 = code | (long)kind.getIndex() << 64 - newUsedBits | (long)newUsedBits;
            }
            return l2;
        }

        private final int compareDebugKinds(TowerGroupKind[] aDebugKinds, TowerGroupKind[] bDebugKinds) {
            int index2;
            for (index2 = 0; index2 < aDebugKinds.length; ++index2) {
                if (index2 >= bDebugKinds.length) {
                    return 1;
                }
                if (aDebugKinds[index2].compareTo(bDebugKinds[index2]) < 0) {
                    return -1;
                }
                if (aDebugKinds[index2].compareTo(bDebugKinds[index2]) <= 0) continue;
                return 1;
            }
            if (index2 < bDebugKinds.length) {
                return -1;
            }
            return 0;
        }

        @NotNull
        public final Comparator<TowerGroupKind[]> getDEBUG_KINDS_COMPARATOR() {
            return DEBUG_KINDS_COMPARATOR;
        }

        private final TowerGroup kindOf(TowerGroupKind kind) {
            return new TowerGroup(this.subscript(0L, kind), this.debugKindArrayOf(kind), null, null, 12, null);
        }

        @NotNull
        public final TowerGroup getEmptyRoot() {
            return EmptyRoot;
        }

        @NotNull
        public final TowerGroup getEmptyRootForInvokeReceiver() {
            return EmptyRootForInvokeReceiver;
        }

        @NotNull
        public final TowerGroup getStart() {
            return Start;
        }

        @NotNull
        public final TowerGroup getQualifierOrClassifier() {
            return QualifierOrClassifier;
        }

        @NotNull
        public final TowerGroup getQualifierValue() {
            return QualifierValue;
        }

        @NotNull
        public final TowerGroup getMember() {
            return Member;
        }

        @NotNull
        public final TowerGroup Local(int depth) {
            return this.kindOf(new TowerGroupKind.Local(depth));
        }

        @NotNull
        public final TowerGroup Implicit(int depth) {
            return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
        }

        @NotNull
        public final TowerGroup NonLocal(int depth) {
            return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
        }

        @NotNull
        public final TowerGroup ContextReceiverGroup(int depth) {
            return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth));
        }

        @NotNull
        public final TowerGroup TopPrioritized(int depth) {
            return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
        }

        @NotNull
        public final TowerGroup getLast() {
            return Last;
        }

        public static final /* synthetic */ int access$compareDebugKinds(Companion $this, TowerGroupKind[] aDebugKinds, TowerGroupKind[] bDebugKinds) {
            return $this.compareDebugKinds(aDebugKinds, bDebugKinds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ TowerGroup access$kindOf(Companion $this, TowerGroupKind kind) {
            return $this.kindOf(kind);
        }
    }
}

