/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.DslScopeViolation;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012*\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0017\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010 \u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckDslScopeViolation;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "dslMarkerClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "implicitlyReferencedSymbolOrNull", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkImpl", "receiverValueToCheck", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "containsAnyOfGivenDslMarkers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "otherDslMarkers", "", "getDslMarkersOfImplicitValue", "boundSymbol", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "collectDslMarkerAnnotations", "", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "resolve"})
public final class CheckDslScopeViolation
extends ResolutionStage {
    @NotNull
    public static final CheckDslScopeViolation INSTANCE = new CheckDslScopeViolation();
    @NotNull
    private static final ClassId dslMarkerClassId = ClassId.Companion.fromString$default(ClassId.Companion, "kotlin/DslMarker", false, 2, null);

    private CheckDslScopeViolation() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        ConeResolutionAtom p0;
        ConeResolutionAtom coneResolutionAtom = candidate.getDispatchReceiver();
        if (coneResolutionAtom != null) {
            p0 = coneResolutionAtom;
            boolean bl = false;
            CheckDslScopeViolation.check$check(candidate, sink, context, p0);
        }
        ConeResolutionAtom coneResolutionAtom2 = candidate.getChosenExtensionReceiver();
        if (coneResolutionAtom2 != null) {
            p0 = coneResolutionAtom2;
            boolean bl = false;
            CheckDslScopeViolation.check$check(candidate, sink, context, p0);
        }
        List<ConeResolutionAtom> list = candidate.getContextArguments();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeResolutionAtom p02 = (ConeResolutionAtom)element$iv;
                boolean bl = false;
                CheckDslScopeViolation.check$check(candidate, sink, context, p02);
            }
        }
        if (callInfo.isImplicitInvoke()) {
            for (ConeResolutionAtom atom : candidate.getArgumentMapping().keySet()) {
                this.checkImpl(atom, candidate, sink, context);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirBasedSymbol<?> implicitlyReferencedSymbolOrNull(FirExpression $this$implicitlyReferencedSymbolOrNull) {
        FirBasedSymbol<?> firBasedSymbol;
        FirExpression firExpression = $this$implicitlyReferencedSymbolOrNull;
        if (firExpression instanceof FirThisReceiverExpression && ((FirThisReceiverExpression)$this$implicitlyReferencedSymbolOrNull).isImplicit()) {
            firBasedSymbol = FirReferenceUtilsKt.getSymbol(((FirThisReceiverExpression)$this$implicitlyReferencedSymbolOrNull).getCalleeReference());
            return firBasedSymbol;
        } else {
            if (!(firExpression instanceof FirPropertyAccessExpression)) return null;
            KtSourceElement ktSourceElement = ((FirPropertyAccessExpression)$this$implicitlyReferencedSymbolOrNull).getSource();
            if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ImplicitContextParameterArgument.INSTANCE)) return null;
            firBasedSymbol = FirReferenceUtilsKt.getSymbol(((FirPropertyAccessExpression)$this$implicitlyReferencedSymbolOrNull).getCalleeReference());
        }
        return firBasedSymbol;
    }

    private final void checkImpl(ConeResolutionAtom receiverValueToCheck, Candidate candidate, CheckerSink sink, ResolutionContext context) {
        boolean bl;
        block9: {
            FirBasedSymbol<?> firBasedSymbol = this.implicitlyReferencedSymbolOrNull(receiverValueToCheck.getExpression());
            if (firBasedSymbol == null) {
                return;
            }
            FirBasedSymbol<?> boundSymbolOfReceiverToCheck = firBasedSymbol;
            Collection collection = this.getDslMarkersOfImplicitValue(boundSymbolOfReceiverToCheck, FirTypeUtilsKt.getResolvedType(receiverValueToCheck.getExpression()), context);
            if (collection.isEmpty()) {
                boolean bl2 = false;
                return;
            }
            Set dslMarkers = (Set)collection;
            Collection<ImplicitValue<?>> implicitValues = context.getBodyResolveContext().getImplicitValueStorage().getImplicitValues();
            FirBasedSymbol memberOwnerOfReceiverToCheck = ResolutionStagesKt.access$containingDeclarationIfParameter(boundSymbolOfReceiverToCheck);
            Iterable $this$dropWhile$iv = implicitValues;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                ImplicitValue it = (ImplicitValue)item$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(memberOwnerOfReceiverToCheck, ResolutionStagesKt.access$containingDeclarationIfParameter(it.getBoundSymbol()))) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            $this$dropWhile$iv = list$iv;
            if ($this$dropWhile$iv.isEmpty()) {
                boolean bl4 = false;
                return;
            }
            List closerOrOnTheSameLevelImplicitValues = (List)$this$dropWhile$iv;
            Iterable $this$any$iv = closerOrOnTheSameLevelImplicitValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ImplicitValue it = (ImplicitValue)element$iv;
                    boolean bl5 = false;
                    if (!(!it.isSameImplicitReceiverInstance(receiverValueToCheck.getExpression()) && INSTANCE.containsAnyOfGivenDslMarkers(it, dslMarkers, context))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            sink.reportDiagnostic(new DslScopeViolation(candidate.getSymbol()));
        }
    }

    private final boolean containsAnyOfGivenDslMarkers(ImplicitValue<?> $this$containsAnyOfGivenDslMarkers, Set<ClassId> otherDslMarkers, ResolutionContext context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getDslMarkersOfImplicitValue((FirBasedSymbol<?>)$this$containsAnyOfGivenDslMarkers.getBoundSymbol(), $this$containsAnyOfGivenDslMarkers.getType(), context);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassId it = (ClassId)element$iv;
                    boolean bl2 = false;
                    if (!otherDslMarkers.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Set<ClassId> getDslMarkersOfImplicitValue(FirBasedSymbol<?> boundSymbol, ConeKotlinType type2, ResolutionContext context) {
        Set<ClassId> set;
        Set<ClassId> $this$getDslMarkersOfImplicitValue_u24lambda_u2410 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        FirBasedSymbol firBasedSymbol = ResolutionStagesKt.access$containingDeclarationIfParameter(boundSymbol);
        FirAnonymousFunctionSymbol firAnonymousFunctionSymbol = firBasedSymbol instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)firBasedSymbol : null;
        if (firAnonymousFunctionSymbol != null) {
            FirAnonymousFunctionSymbol anonymousFunctionSymbol = firAnonymousFunctionSymbol;
            boolean bl2 = false;
            ConeKotlinType coneKotlinType = ClassMembersKt.getMatchingParameterFunctionType((FirAnonymousFunction)anonymousFunctionSymbol.getFir());
            if (coneKotlinType != null) {
                ConeKotlinType matchingParameterFunctionType = coneKotlinType;
                INSTANCE.collectDslMarkerAnnotations($this$getDslMarkersOfImplicitValue_u24lambda_u2410, context, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(matchingParameterFunctionType));
                if (boundSymbol instanceof FirValueParameterSymbol) {
                    int index2 = anonymousFunctionSymbol.getContextParameterSymbols().indexOf(boundSymbol);
                    ConeKotlinType coneKotlinType2 = CollectionsKt.getOrNull(FunctionalTypeUtilsKt.contextParameterTypes(matchingParameterFunctionType, context.getSession()), index2);
                    if (coneKotlinType2 != null) {
                        ConeKotlinType contextType = coneKotlinType2;
                        boolean bl3 = false;
                        INSTANCE.collectDslMarkerAnnotations($this$getDslMarkersOfImplicitValue_u24lambda_u2410, context, contextType);
                    }
                }
                if (boundSymbol instanceof FirReceiverParameterSymbol) {
                    ConeKotlinType coneKotlinType3 = FunctionalTypeUtilsKt.receiverType(matchingParameterFunctionType, context.getSession());
                    if (coneKotlinType3 != null) {
                        ConeKotlinType receiverType = coneKotlinType3;
                        boolean bl4 = false;
                        INSTANCE.collectDslMarkerAnnotations($this$getDslMarkersOfImplicitValue_u24lambda_u2410, context, receiverType);
                    }
                }
            }
        }
        INSTANCE.collectDslMarkerAnnotations($this$getDslMarkersOfImplicitValue_u24lambda_u2410, context, type2);
        return SetsKt.build(set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void collectDslMarkerAnnotations(Set<ClassId> $this$collectDslMarkerAnnotations, ResolutionContext context, ConeKotlinType type2) {
        ConeKotlinType originalType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(type2);
        this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(originalType));
        ConeKotlinType coneKotlinType = originalType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, ((ConeFlexibleType)originalType).getLowerBound());
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, ((ConeFlexibleType)originalType).getUpperBound());
            return;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            if (((ConeCapturedType)originalType).getConstructor().getProjection().getKind() != ProjectionKind.OUT) return;
            List<ConeKotlinType> list = ((ConeCapturedType)originalType).getConstructor().getSupertypes();
            if (list == null) return;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, it);
            }
            return;
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, ((ConeDefinitelyNotNullType)originalType).getOriginal());
            return;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)originalType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, it);
            }
            return;
        } else {
            if (!(coneKotlinType instanceof ConeClassLikeType)) return;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((ConeClassLikeType)originalType, context.getSession());
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> classDeclaration = firClassLikeSymbol;
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, (Collection<? extends FirAnnotation>)classDeclaration.getResolvedAnnotationsWithClassIds());
            FirClassLikeSymbol<?> firClassLikeSymbol2 = classDeclaration;
            if (firClassLikeSymbol2 instanceof FirClassSymbol) {
                for (ConeKotlinType superType : ((FirClassSymbol)classDeclaration).getResolvedSuperTypes()) {
                    this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, superType);
                }
                return;
            } else {
                if (!(firClassLikeSymbol2 instanceof FirTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
                ConeClassLikeType coneClassLikeType = TypeExpansionUtilsKt.directExpansionType$default((ConeClassLikeType)originalType, context.getSession(), null, 2, null);
                if (coneClassLikeType == null) return;
                ConeClassLikeType it = coneClassLikeType;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context, it);
            }
        }
    }

    private final void collectDslMarkerAnnotations(Set<ClassId> $this$collectDslMarkerAnnotations, ResolutionContext context, Collection<? extends FirAnnotation> annotations2) {
        for (FirAnnotation firAnnotation : annotations2) {
            FirClassSymbol<?> annotationClass;
            if (ToSymbolUtilsKt.toClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef()), context.getSession(), null, 2, null), context.getSession()) == null || !FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)annotationClass, dslMarkerClassId, context.getSession())) continue;
            $this$collectDslMarkerAnnotations.add(annotationClass.getClassId());
        }
    }

    private static final void check$check(Candidate $candidate, CheckerSink $sink, ResolutionContext $context, ConeResolutionAtom atom) {
        INSTANCE.checkImpl(atom, $candidate, $sink, $context);
    }
}

