/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.candidate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirErrorReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStageRunner;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a0\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\"\u0010\u000f\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"createErrorReferenceWithErrorCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/FirErrorReferenceWithCandidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "resolutionContext", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "resolutionStageRunner", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;", "createErrorReferenceWithExistingCandidate", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "createErrorCandidate", "fullyProcessCandidate", "", "resolve"})
public final class ErrorCandidateUtilsKt {
    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithErrorCandidate(@NotNull CallInfo callInfo, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        return new FirErrorReferenceWithCandidate(source, callInfo.getName(), ErrorCandidateUtilsKt.createErrorCandidate(resolutionStageRunner, callInfo, resolutionContext, diagnostic), diagnostic);
    }

    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithExistingCandidate(@NotNull Candidate candidate, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        ErrorCandidateUtilsKt.fullyProcessCandidate(resolutionStageRunner, candidate, resolutionContext);
        return new FirErrorReferenceWithCandidate(source, candidate.getCallInfo().getName(), candidate, diagnostic);
    }

    @NotNull
    public static final Candidate createErrorCandidate(@NotNull ResolutionStageRunner $this$createErrorCandidate, @NotNull CallInfo callInfo, @NotNull ResolutionContext resolutionContext, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter($this$createErrorCandidate, "<this>");
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Candidate candidate = new CandidateFactory(resolutionContext, callInfo).createErrorCandidate(callInfo, diagnostic);
        $this$createErrorCandidate.processCandidate(candidate, resolutionContext, false);
        return candidate;
    }

    public static final void fullyProcessCandidate(@NotNull ResolutionStageRunner $this$fullyProcessCandidate, @NotNull Candidate candidate, @NotNull ResolutionContext resolutionContext) {
        Intrinsics.checkNotNullParameter($this$fullyProcessCandidate, "<this>");
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        if (!CandidateKt.getFullyAnalyzed(candidate)) {
            $this$fullyProcessCandidate.processCandidate(candidate, resolutionContext, false);
        }
    }
}

