/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceConversionStrategy;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\b\u0012\u0004\u0012\u00020\r`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010\u001e\u001a\u00020\u001fR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceAdaptation;", "", "argumentTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coercionStrategy", "Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "defaults", "", "mappedArguments", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceMappedArguments;", "suspendConversionStrategy", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "<init>", "([Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;ILjava/util/Map;Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;)V", "getArgumentTypes", "()[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getCoercionStrategy", "()Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "getDefaults", "()I", "getMappedArguments", "()Ljava/util/Map;", "getSuspendConversionStrategy", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "hasFunctionKindConversion", "", "resolve"})
public final class CallableReferenceAdaptation {
    @NotNull
    private final ConeKotlinType[] argumentTypes;
    @NotNull
    private final CoercionStrategy coercionStrategy;
    private final int defaults;
    @NotNull
    private final Map<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> mappedArguments;
    @NotNull
    private final CallableReferenceConversionStrategy suspendConversionStrategy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableReferenceAdaptation(@NotNull ConeKotlinType[] argumentTypes, @NotNull CoercionStrategy coercionStrategy, int defaults, @NotNull Map<FirValueParameter, ? extends ResolvedCallArgument<? extends ConeResolutionAtom>> mappedArguments, @NotNull CallableReferenceConversionStrategy suspendConversionStrategy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter((Object)coercionStrategy, "coercionStrategy");
        Intrinsics.checkNotNullParameter(mappedArguments, "mappedArguments");
        Intrinsics.checkNotNullParameter(suspendConversionStrategy, "suspendConversionStrategy");
        this.argumentTypes = argumentTypes;
        this.coercionStrategy = coercionStrategy;
        this.defaults = defaults;
        this.mappedArguments = mappedArguments;
        this.suspendConversionStrategy = suspendConversionStrategy;
        if (!AbstractTypeChecker.RUN_SLOW_ASSERTIONS) return;
        if (this.defaults != 0) return;
        if (this.hasFunctionKindConversion()) return;
        if (this.coercionStrategy != CoercionStrategy.NO_COERCION) return;
        Iterable $this$any$iv = this.mappedArguments.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl2 = false;
                if (!(it instanceof ResolvedCallArgument.VarargArgument)) continue;
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = false;
        if (bl3) return;
        boolean bl4 = false;
        String string = "Adaptation must be non-trivial.";
        throw new IllegalArgumentException(string.toString());
    }

    @NotNull
    public final ConeKotlinType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    @NotNull
    public final CoercionStrategy getCoercionStrategy() {
        return this.coercionStrategy;
    }

    public final int getDefaults() {
        return this.defaults;
    }

    @NotNull
    public final Map<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getMappedArguments() {
        return this.mappedArguments;
    }

    @NotNull
    public final CallableReferenceConversionStrategy getSuspendConversionStrategy() {
        return this.suspendConversionStrategy;
    }

    public final boolean hasFunctionKindConversion() {
        return !Intrinsics.areEqual(this.suspendConversionStrategy, CallableReferenceConversionStrategy.NoConversion.INSTANCE);
    }
}

