/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00060\u000fR\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirPropertyAccessorRenderer;", "", "<init>", "()V", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "printer", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "visitor", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "render", "", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "tree"})
public final class FirPropertyAccessorRenderer {
    public FirRendererComponents components;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    private final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    private final FirRenderer.Visitor getVisitor() {
        return this.getComponents$tree().getVisitor();
    }

    public final void render(@NotNull FirProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        this.getPrinter().println(new Object[0]);
        this.getPrinter().pushIndent$tree();
        if (DeclarationAttributesKt.getHasExplicitBackingField(property)) {
            FirBackingField firBackingField = property.getBackingField();
            if (firBackingField != null) {
                firBackingField.accept(this.getVisitor());
            }
            this.getPrinter().println(new Object[0]);
        }
        FirPropertyAccessor firPropertyAccessor = property.getGetter();
        if (firPropertyAccessor != null) {
            firPropertyAccessor.accept(this.getVisitor());
        }
        FirPropertyAccessor firPropertyAccessor2 = property.getGetter();
        if ((firPropertyAccessor2 != null ? firPropertyAccessor2.getBody() : null) == null) {
            this.getPrinter().println(new Object[0]);
        }
        if (property.isVar()) {
            FirPropertyAccessor firPropertyAccessor3 = property.getSetter();
            if (firPropertyAccessor3 != null) {
                firPropertyAccessor3.accept(this.getVisitor());
            }
            FirPropertyAccessor firPropertyAccessor4 = property.getSetter();
            if ((firPropertyAccessor4 != null ? firPropertyAccessor4.getBody() : null) == null) {
                this.getPrinter().println(new Object[0]);
            }
        }
        this.getPrinter().popIndent$tree();
    }
}

