/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.PackagePartsCacheData;
import org.jetbrains.kotlin.fir.resolve.providers.FirCachedSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u00103\u001a\u00020!H$J\u0010\u00104\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H$J\u0018\u00105\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u00103\u001a\u00020!H$J\u001e\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020(2\n\b\u0002\u00109\u001a\u0004\u0018\u00010*H$J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H$J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u00103\u001a\u00020!H\u0002J2\u0010?\u001a$\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020B\u0018\u00010Aj\u0004\u0018\u0001`C0@2\u0006\u00108\u001a\u00020(H\u0002J>\u0010D\u001a$\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020B\u0018\u00010Aj\u0004\u0018\u0001`E0@2\u0006\u00108\u001a\u00020(2\n\b\u0002\u00109\u001a\u0004\u0018\u00010*H\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020/0%2\u0006\u0010G\u001a\u00020.H\u0002J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u0002010%2\u0006\u0010G\u001a\u00020.H\u0002J \u0010I\u001a\u00020B2\u0006\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J \u0010O\u001a\u00020B2\u0006\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020P2\u0006\u0010M\u001a\u00020QH\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020&0S2\u0006\u00103\u001a\u00020!H\u0002J\u001e\u0010T\u001a\u0004\u0018\u00010,2\u0006\u00108\u001a\u00020(2\n\b\u0002\u00109\u001a\u0004\u0018\u00010*H\u0004J\u0012\u0010U\u001a\u0004\u0018\u00010)2\u0006\u00108\u001a\u00020(H\u0002J*\u0010V\u001a\u00020B2\u0010\u0010W\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Y0X2\u0006\u00103\u001a\u00020!2\u0006\u0010Z\u001a\u00020\"H\u0017JB\u0010[\u001a\b\u0012\u0004\u0012\u0002H\\0%\"\f\b\u0000\u0010\\*\u0006\u0012\u0002\b\u00030Y*\u001c\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\\0%\u0012\u0006\u0012\u0004\u0018\u00010#0 2\u0006\u0010]\u001a\u00020.H\u0002J&\u0010^\u001a\u00020B2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020/0X2\u0006\u00103\u001a\u00020!2\u0006\u0010Z\u001a\u00020\"H\u0017J&\u0010_\u001a\u00020B2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002010X2\u0006\u00103\u001a\u00020!2\u0006\u0010Z\u001a\u00020\"H\u0017J\u0016\u0010`\u001a\b\u0012\u0002\b\u0003\u0018\u00010a2\u0006\u00108\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR(\u0010\u001f\u001a\u001c\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u0015\u0012\u0006\u0012\u0004\u0018\u00010#0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010$\u001a\u001c\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%\u0012\u0006\u0012\u0004\u0018\u00010#0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u0018\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0006\u0012\u0004\u0018\u00010*0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u0018\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0006\u0012\u0004\u0018\u00010*0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010-\u001a\u001c\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0%\u0012\u0006\u0012\u0004\u0018\u00010#0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00100\u001a\u001c\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u0002010%\u0012\u0006\u0012\u0004\u0018\u00010#0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "defaultDeserializationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "serializerExtensionProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "getModuleDataProvider", "()Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getDefaultDeserializationOrigin", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "packageNamesForNonClassDeclarations", "", "", "getPackageNamesForNonClassDeclarations", "()Ljava/util/Set;", "packageNamesForNonClassDeclarations$delegate", "Lkotlin/Lazy;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "typeAliasesNamesByPackage", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/Name;", "", "packagePartsCache", "", "Lorg/jetbrains/kotlin/fir/deserialization/PackagePartsCacheData;", "typeAliasCache", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "classCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "functionCache", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "computePackagePartsInfos", "packageFqName", "computePackageSetWithNonClassDeclarations", "knownTopLevelClassesInPackage", "extractClassMetadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "classId", "parentContext", "isNewPlaceForBodyGeneration", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "tryComputePackagePartInfos", "findAndDeserializeTypeAlias", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/deserialization/DeserializedTypeAliasPostProcessor;", "findAndDeserializeClass", "Lorg/jetbrains/kotlin/fir/deserialization/DeserializedClassPostProcessor;", "loadFunctionsByCallableId", "callableId", "loadPropertiesByCallableId", "loadFunctionExtensions", "packagePart", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "fir", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "loadPropertyExtensions", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getPackageParts", "", "getClass", "getTypeAlias", "getTopLevelCallableSymbolsTo", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "getCallables", "C", "id", "getTopLevelFunctionSymbolsTo", "getTopLevelPropertySymbolsTo", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "ClassMetadataFindResult", "fir-deserialization"})
public abstract class AbstractFirDeserializedSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final ModuleDataProvider moduleDataProvider;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirDeclarationOrigin defaultDeserializationOrigin;
    @NotNull
    private final SerializerExtensionProtocol serializerExtensionProtocol;
    @NotNull
    private final Lazy packageNamesForNonClassDeclarations$delegate;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;
    @NotNull
    private final FirCache typeAliasesNamesByPackage;
    @NotNull
    private final FirCache packagePartsCache;
    @NotNull
    private final FirCache<ClassId, FirTypeAliasSymbol, FirDeserializationContext> typeAliasCache;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
    @NotNull
    private final FirCache functionCache;
    @NotNull
    private final FirCache propertyCache;

    public AbstractFirDeserializedSymbolProvider(@NotNull FirSession session, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider2, @NotNull FirDeclarationOrigin defaultDeserializationOrigin, @NotNull SerializerExtensionProtocol serializerExtensionProtocol) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(moduleDataProvider, "moduleDataProvider");
        Intrinsics.checkNotNullParameter(kotlinScopeProvider2, "kotlinScopeProvider");
        Intrinsics.checkNotNullParameter(defaultDeserializationOrigin, "defaultDeserializationOrigin");
        Intrinsics.checkNotNullParameter(serializerExtensionProtocol, "serializerExtensionProtocol");
        super(session);
        this.moduleDataProvider = moduleDataProvider;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.defaultDeserializationOrigin = defaultDeserializationOrigin;
        this.serializerExtensionProtocol = serializerExtensionProtocol;
        this.packageNamesForNonClassDeclarations$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> AbstractFirDeserializedSymbolProvider.packageNamesForNonClassDeclarations_delegate$lambda$0(this));
        this.symbolNamesProvider = new FirCachedSymbolNamesProvider(session, this){
            final /* synthetic */ AbstractFirDeserializedSymbolProvider this$0;
            {
                this.this$0 = $receiver;
                super($session);
            }

            public Set<String> computePackageNames() {
                return null;
            }

            public boolean getHasSpecificClassifierPackageNamesComputation() {
                return false;
            }

            public Set<String> computePackageNamesWithTopLevelClassifiers() {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> computeTopLevelClassifierNames(FqName packageFqName) {
                Set<E> set;
                Set<String> set2;
                block10: {
                    block9: {
                        Set<String> set3;
                        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                        set2 = this.this$0.knownTopLevelClassesInPackage(packageFqName);
                        if (set2 == null) break block9;
                        Collection $this$mapToSetOrEmpty$iv = set2;
                        boolean $i$f$mapToSetOrEmpty = false;
                        if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                            void destination$iv$iv;
                            void $this$mapTo$iv$iv;
                            Iterable iterable = $this$mapToSetOrEmpty$iv;
                            Collection collection = new LinkedHashSet<E>();
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                String string = (String)item$iv$iv;
                                void var14_13 = destination$iv$iv;
                                boolean bl = false;
                                var14_13.add(Name.identifier((String)it));
                            }
                            set3 = (Set)destination$iv$iv;
                        } else {
                            set3 = set2 = SetsKt.emptySet();
                        }
                        if (set3 != null) break block10;
                    }
                    return null;
                }
                Set<String> classesInPackage = set2;
                Set set4 = AbstractFirDeserializedSymbolProvider.access$getPackageNamesForNonClassDeclarations(this.this$0);
                if (set4 != null) {
                    Set it = set4;
                    boolean bl = false;
                    if (!it.contains(packageFqName.asString())) {
                        return classesInPackage;
                    }
                }
                FirCache $this$getValue$iv = AbstractFirDeserializedSymbolProvider.access$getTypeAliasesNamesByPackage$p(this.this$0);
                boolean $i$f$getValue = false;
                Set typeAliasNames = (Set)$this$getValue$iv.getValue(packageFqName, null);
                if (typeAliasNames.isEmpty()) {
                    return classesInPackage;
                }
                Set<E> $this$computeTopLevelClassifierNames_u24lambda_u242 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$computeTopLevelClassifierNames_u24lambda_u242.addAll(classesInPackage);
                $this$computeTopLevelClassifierNames_u24lambda_u242.addAll(typeAliasNames);
                return SetsKt.build(set);
            }

            public boolean getHasSpecificCallablePackageNamesComputation() {
                return true;
            }

            public Set<String> getPackageNamesWithTopLevelCallables() {
                return AbstractFirDeserializedSymbolProvider.access$getPackageNamesForNonClassDeclarations(this.this$0);
            }

            public Set<String> computePackageNamesWithTopLevelCallables() {
                return AbstractFirDeserializedSymbolProvider.access$getPackageNamesForNonClassDeclarations(this.this$0);
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> computeTopLevelCallableNames(FqName packageFqName) {
                void var3_3;
                void $this$flatMapTo$iv;
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Iterable iterable = AbstractFirDeserializedSymbolProvider.access$getPackageParts(this.this$0, packageFqName);
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    PackagePartsCacheData it = (PackagePartsCacheData)element$iv;
                    boolean bl = false;
                    Iterable list$iv = SetsKt.plus(it.getTopLevelFunctionNameIndex().keySet(), (Iterable)it.getTopLevelPropertyNameIndex().keySet());
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                return (Set)var3_3;
            }
        };
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        boolean $i$f$createCache = false;
        this.typeAliasesNamesByPackage = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolProvider this$0;
            {
                this.this$0 = abstractFirDeserializedSymbolProvider;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Object invoke(Object key, Void void_) {
                void destination$iv;
                void $this$flatMapTo$iv;
                Intrinsics.checkNotNullParameter(key, "key");
                FqName fqName2 = (FqName)key;
                boolean bl = false;
                Iterable iterable = AbstractFirDeserializedSymbolProvider.access$getPackageParts(this.this$0, fqName2);
                Collection collection = new LinkedHashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    PackagePartsCacheData it = (PackagePartsCacheData)element$iv;
                    boolean bl2 = false;
                    Iterable list$iv = it.getTypeAliasNameIndex().keySet();
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                return (Set)destination$iv;
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.packagePartsCache = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolProvider;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(Object key, Void void_) {
                Intrinsics.checkNotNullParameter(key, "key");
                FqName p0 = (FqName)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolProvider.access$tryComputePackagePartInfos(this.$receiver$inlined, p0);
            }
        });
        this.typeAliasCache = FirCachesFactoryKt.getFirCachesFactory(session).createCacheWithPostCompute((arg_0, arg_1) -> AbstractFirDeserializedSymbolProvider.typeAliasCache$lambda$3(this, arg_0, arg_1), AbstractFirDeserializedSymbolProvider::typeAliasCache$lambda$4);
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session).createCacheWithPostCompute((arg_0, arg_1) -> AbstractFirDeserializedSymbolProvider.classCache$lambda$5(this, arg_0, arg_1), AbstractFirDeserializedSymbolProvider::classCache$lambda$6);
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.functionCache = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolProvider;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(Object key, Void void_) {
                Intrinsics.checkNotNullParameter(key, "key");
                CallableId p0 = (CallableId)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolProvider.access$loadFunctionsByCallableId(this.$receiver$inlined, p0);
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.propertyCache = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolProvider;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(Object key, Void void_) {
                Intrinsics.checkNotNullParameter(key, "key");
                CallableId p0 = (CallableId)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolProvider.access$loadPropertiesByCallableId(this.$receiver$inlined, p0);
            }
        });
    }

    @NotNull
    public final ModuleDataProvider getModuleDataProvider() {
        return this.moduleDataProvider;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @NotNull
    public final FirDeclarationOrigin getDefaultDeserializationOrigin() {
        return this.defaultDeserializationOrigin;
    }

    private final Set<String> getPackageNamesForNonClassDeclarations() {
        Lazy lazy = this.packageNamesForNonClassDeclarations$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @NotNull
    protected abstract List<PackagePartsCacheData> computePackagePartsInfos(@NotNull FqName var1);

    @Nullable
    protected abstract Set<String> computePackageSetWithNonClassDeclarations();

    @Nullable
    protected abstract Set<String> knownTopLevelClassesInPackage(@NotNull FqName var1);

    @Nullable
    protected abstract ClassMetadataFindResult extractClassMetadata(@NotNull ClassId var1, @Nullable FirDeserializationContext var2);

    public static /* synthetic */ ClassMetadataFindResult extractClassMetadata$default(AbstractFirDeserializedSymbolProvider abstractFirDeserializedSymbolProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractClassMetadata");
        }
        if ((n2 & 2) != 0) {
            firDeserializationContext = null;
        }
        return abstractFirDeserializedSymbolProvider.extractClassMetadata(classId, firDeserializationContext);
    }

    protected abstract boolean isNewPlaceForBodyGeneration(@NotNull ProtoBuf.Class var1);

    private final List<PackagePartsCacheData> tryComputePackagePartInfos(FqName packageFqName) {
        return this.computePackagePartsInfos(packageFqName);
    }

    private final Pair<FirTypeAliasSymbol, Function1<FirTypeAliasSymbol, Unit>> findAndDeserializeTypeAlias(ClassId classId) {
        Pair<Object, Object> pair;
        Pair<Object, Object> pair2;
        block4: {
            for (PackagePartsCacheData part : (Iterable)this.getPackageParts(classId.getPackageFqName())) {
                Pair<FirTypeAliasSymbol, Function1<FirTypeAliasSymbol, Unit>> pair3;
                Pair<FirTypeAliasSymbol, Function1<FirTypeAliasSymbol, Unit>> pair4;
                boolean bl = false;
                List<Integer> ids = part.getTypeAliasNameIndex().get(classId.getShortClassName());
                if (ids == null || ids.isEmpty()) {
                    pair4 = null;
                } else {
                    ProtoBuf.TypeAlias aliasProto = part.getProto().getTypeAlias(((Number)CollectionsKt.single(ids)).intValue());
                    Function1<FirTypeAliasSymbol, Unit> postProcessor = arg_0 -> AbstractFirDeserializedSymbolProvider.findAndDeserializeTypeAlias$lambda$10$lambda$9(part, aliasProto, this, arg_0);
                    pair4 = TuplesKt.to(new FirTypeAliasSymbol(classId), postProcessor);
                }
                if ((pair3 = pair4) == null) continue;
                pair2 = pair3;
                break block4;
            }
            pair2 = pair = null;
        }
        if (pair2 == null) {
            pair = TuplesKt.to(null, null);
        }
        return pair;
    }

    private final Pair<FirRegularClassSymbol, Function1<FirRegularClassSymbol, Unit>> findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
        Pair<FirRegularClassSymbol, Function1<FirRegularClassSymbol, Unit>> pair;
        ClassMetadataFindResult result2 = this.extractClassMetadata(classId, parentContext);
        if (result2 instanceof ClassMetadataFindResult.NoMetadata) {
            pair = TuplesKt.to(new FirRegularClassSymbol(classId), ((ClassMetadataFindResult.NoMetadata)result2).getClassPostProcessor());
        } else if (result2 instanceof ClassMetadataFindResult.Metadata) {
            ClassMetadataFindResult classMetadataFindResult = result2;
            NameResolver nameResolver = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component1();
            ProtoBuf.Class classProto = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component2();
            AbstractAnnotationDeserializer annotationDeserializer2 = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component3();
            FirModuleData moduleData2 = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component4();
            DeserializedContainerSource sourceElement = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component5();
            if (moduleData2 == null) {
                return TuplesKt.to(null, null);
            }
            FirRegularClassSymbol symbol = new FirRegularClassSymbol(classId);
            ClassDeserializationKt.deserializeClassToSymbol(classId, classProto, symbol, nameResolver, this.getSession(), moduleData2, annotationDeserializer2, ((ClassMetadataFindResult.Metadata)result2).getFlexibleTypeFactory(), this.kotlinScopeProvider, this.serializerExtensionProtocol, parentContext, sourceElement, this.defaultDeserializationOrigin, (Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol>)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>((Object)this){

                public final FirRegularClassSymbol invoke(ClassId p0, FirDeserializationContext p1) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((AbstractFirDeserializedSymbolProvider)this.receiver).getClass(p0, p1);
                }
            });
            ClassMembersKt.setNewPlaceForBodyGeneration((FirRegularClass)symbol.getFir(), this.isNewPlaceForBodyGeneration(classProto));
            pair = TuplesKt.to(symbol, null);
        } else if (result2 == null) {
            pair = TuplesKt.to(null, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirNamedFunctionSymbol> loadFunctionsByCallableId(CallableId callableId) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getPackageParts(callableId.getPackageName());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv$iv;
            boolean bl = false;
            if (part.getTopLevelFunctionNameIndex().get(callableId.getCallableName()) == null) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                List<Integer> functionIds;
                Iterable $this$map$iv = functionIds;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n2 = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    ProtoBuf.Function proto = part.getProto().getFunction((int)it);
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    ProtoBuf.Function function2 = part.getProto().getFunction((int)it);
                    Intrinsics.checkNotNullExpressionValue(function2, "getFunction(...)");
                    FirSimpleFunction fir = FirMemberDeserializer.loadFunction$default(firMemberDeserializer, function2, null, null, this.defaultDeserializationOrigin, 6, null);
                    Intrinsics.checkNotNull(proto);
                    this.loadFunctionExtensions(part, proto, fir);
                    collection.add(fir.getSymbol());
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirPropertySymbol> loadPropertiesByCallableId(CallableId callableId) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getPackageParts(callableId.getPackageName());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv$iv;
            boolean bl = false;
            if (part.getTopLevelPropertyNameIndex().get(callableId.getCallableName()) == null) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                List<Integer> propertyIds;
                Iterable $this$map$iv = propertyIds;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n2 = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    ProtoBuf.Property proto = part.getProto().getProperty((int)it);
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    Intrinsics.checkNotNull(proto);
                    FirProperty fir = FirMemberDeserializer.loadProperty$default(firMemberDeserializer, proto, null, null, 6, null);
                    this.loadPropertyExtensions(part, proto, fir);
                    collection.add(fir.getSymbol());
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void loadFunctionExtensions(@NotNull PackagePartsCacheData packagePart, @NotNull ProtoBuf.Function proto, @NotNull FirFunction fir) {
        Intrinsics.checkNotNullParameter(packagePart, "packagePart");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(fir, "fir");
    }

    public void loadPropertyExtensions(@NotNull PackagePartsCacheData packagePart, @NotNull ProtoBuf.Property proto, @NotNull FirProperty fir) {
        Intrinsics.checkNotNullParameter(packagePart, "packagePart");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(fir, "fir");
    }

    private final Collection<PackagePartsCacheData> getPackageParts(FqName packageFqName) {
        FirCache $this$getValue$iv = this.packagePartsCache;
        boolean $i$f$getValue = false;
        return (Collection)$this$getValue$iv.getValue(packageFqName, null);
    }

    @Nullable
    protected final FirRegularClassSymbol getClass(@NotNull ClassId classId, @Nullable FirDeserializationContext parentContext) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        ClassId parentClassId = classId.getOuterClassId();
        if (parentClassId == null && !this.getSymbolNamesProvider().mayHaveTopLevelClassifier(classId)) {
            return null;
        }
        if (parentClassId != null && !this.getSymbolNamesProvider().mayHaveTopLevelClassifier(classId.getOutermostClassId())) {
            return null;
        }
        if (parentContext == null && parentClassId != null) {
            FirRegularClassSymbol alreadyLoaded = this.classCache.getValueIfComputed(classId);
            if (alreadyLoaded != null) {
                return alreadyLoaded;
            }
            this.getClass(parentClassId, null);
        }
        return this.classCache.getValue(classId, parentContext);
    }

    public static /* synthetic */ FirRegularClassSymbol getClass$default(AbstractFirDeserializedSymbolProvider abstractFirDeserializedSymbolProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getClass");
        }
        if ((n2 & 2) != 0) {
            firDeserializationContext = null;
        }
        return abstractFirDeserializedSymbolProvider.getClass(classId, firDeserializationContext);
    }

    private final FirTypeAliasSymbol getTypeAlias(ClassId classId) {
        if (!FqNamesUtilKt.isOneSegmentFQN(classId.getRelativeClassName())) {
            return null;
        }
        FqName packageFqName = classId.getPackageFqName();
        Set<String> set = this.getPackageNamesForNonClassDeclarations();
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            if (!it.contains(packageFqName.asString())) {
                return null;
            }
        }
        FirCache<ClassId, FirTypeAliasSymbol, FirDeserializationContext> $this$getValue$iv = this.typeAliasesNamesByPackage;
        boolean $i$f$getValue = false;
        if (!((Set)$this$getValue$iv.getValue((ClassId)((Object)packageFqName), (FirDeserializationContext)null)).contains(classId.getShortClassName())) {
            return null;
        }
        $this$getValue$iv = this.typeAliasCache;
        $i$f$getValue = false;
        return $this$getValue$iv.getValue(classId, null);
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        CallableId callableId = new CallableId(packageFqName, name);
        CollectionsKt.addAll((Collection)destination, this.getCallables(this.functionCache, callableId));
        CollectionsKt.addAll((Collection)destination, this.getCallables(this.propertyCache, callableId));
    }

    private final <C extends FirCallableSymbol<?>> List<C> getCallables(FirCache $this$getCallables, CallableId id) {
        if (!this.getSymbolNamesProvider().mayHaveTopLevelCallable(id.getPackageName(), id.getCallableName())) {
            return CollectionsKt.emptyList();
        }
        FirCache $this$getValue$iv = $this$getCallables;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue(id, null);
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        CollectionsKt.addAll((Collection)destination, this.getCallables(this.functionCache, new CallableId(packageFqName, name)));
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        CollectionsKt.addAll((Collection)destination, this.getCallables(this.propertyCache, new CallableId(packageFqName, name)));
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirRegularClassSymbol clazz = AbstractFirDeserializedSymbolProvider.getClass$default(this, classId, null, 2, null);
        if (clazz != null) {
            FirClassLikeSymbol $this$isExpect$iv = clazz;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getRawStatus().isExpect()) {
                return clazz;
            }
        }
        FirTypeAliasSymbol firTypeAliasSymbol = this.getTypeAlias(classId);
        return firTypeAliasSymbol != null ? (FirClassLikeSymbol)firTypeAliasSymbol : (FirClassLikeSymbol)clazz;
    }

    private static final Set packageNamesForNonClassDeclarations_delegate$lambda$0(AbstractFirDeserializedSymbolProvider this$0) {
        return this$0.computePackageSetWithNonClassDeclarations();
    }

    private static final Pair typeAliasCache$lambda$3(AbstractFirDeserializedSymbolProvider this$0, ClassId classId, FirDeserializationContext firDeserializationContext) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this$0.findAndDeserializeTypeAlias(classId);
    }

    private static final Unit typeAliasCache$lambda$4(ClassId classId, FirTypeAliasSymbol symbol, Function1 postProcessor) {
        Intrinsics.checkNotNullParameter(classId, "<unused var>");
        if (postProcessor != null && symbol != null) {
            postProcessor.invoke(symbol);
        }
        return Unit.INSTANCE;
    }

    private static final Pair classCache$lambda$5(AbstractFirDeserializedSymbolProvider this$0, ClassId classId, FirDeserializationContext context) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this$0.findAndDeserializeClass(classId, context);
    }

    private static final Unit classCache$lambda$6(ClassId classId, FirRegularClassSymbol symbol, Function1 postProcessor) {
        Intrinsics.checkNotNullParameter(classId, "<unused var>");
        if (postProcessor != null && symbol != null) {
            postProcessor.invoke(symbol);
        }
        return Unit.INSTANCE;
    }

    private static final Unit findAndDeserializeTypeAlias$lambda$10$lambda$9(PackagePartsCacheData $part, ProtoBuf.TypeAlias $aliasProto, AbstractFirDeserializedSymbolProvider this$0, FirTypeAliasSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FirMemberDeserializer firMemberDeserializer = $part.getContext().getMemberDeserializer();
        Intrinsics.checkNotNull($aliasProto);
        firMemberDeserializer.loadTypeAlias($aliasProto, this$0.kotlinScopeProvider, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Collection access$getPackageParts(AbstractFirDeserializedSymbolProvider $this, FqName packageFqName) {
        return $this.getPackageParts(packageFqName);
    }

    public static final /* synthetic */ List access$tryComputePackagePartInfos(AbstractFirDeserializedSymbolProvider $this, FqName packageFqName) {
        return $this.tryComputePackagePartInfos(packageFqName);
    }

    public static final /* synthetic */ List access$loadFunctionsByCallableId(AbstractFirDeserializedSymbolProvider $this, CallableId callableId) {
        return $this.loadFunctionsByCallableId(callableId);
    }

    public static final /* synthetic */ List access$loadPropertiesByCallableId(AbstractFirDeserializedSymbolProvider $this, CallableId callableId) {
        return $this.loadPropertiesByCallableId(callableId);
    }

    public static final /* synthetic */ Set access$getPackageNamesForNonClassDeclarations(AbstractFirDeserializedSymbolProvider $this) {
        return $this.getPackageNamesForNonClassDeclarations();
    }

    public static final /* synthetic */ FirCache access$getTypeAliasesNamesByPackage$p(AbstractFirDeserializedSymbolProvider $this) {
        return $this.typeAliasesNamesByPackage;
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "", "<init>", "()V", "NoMetadata", "Metadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult$Metadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult$NoMetadata;", "fir-deserialization"})
    public static abstract class ClassMetadataFindResult {
        private ClassMetadataFindResult() {
        }

        public /* synthetic */ ClassMetadataFindResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003JK\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult$Metadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "sourceElement", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "flexibleTypeFactory", "Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;)V", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "getClassProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getAnnotationDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "getSourceElement", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getFlexibleTypeFactory", "()Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fir-deserialization"})
        public static final class Metadata
        extends ClassMetadataFindResult {
            @NotNull
            private final NameResolver nameResolver;
            @NotNull
            private final ProtoBuf.Class classProto;
            @Nullable
            private final AbstractAnnotationDeserializer annotationDeserializer;
            @Nullable
            private final FirModuleData moduleData;
            @Nullable
            private final DeserializedContainerSource sourceElement;
            @NotNull
            private final FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory;

            public Metadata(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto, @Nullable AbstractAnnotationDeserializer annotationDeserializer2, @Nullable FirModuleData moduleData2, @Nullable DeserializedContainerSource sourceElement, @NotNull FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory) {
                Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
                Intrinsics.checkNotNullParameter(classProto, "classProto");
                Intrinsics.checkNotNullParameter(flexibleTypeFactory, "flexibleTypeFactory");
                super(null);
                this.nameResolver = nameResolver;
                this.classProto = classProto;
                this.annotationDeserializer = annotationDeserializer2;
                this.moduleData = moduleData2;
                this.sourceElement = sourceElement;
                this.flexibleTypeFactory = flexibleTypeFactory;
            }

            @NotNull
            public final NameResolver getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public final ProtoBuf.Class getClassProto() {
                return this.classProto;
            }

            @Nullable
            public final AbstractAnnotationDeserializer getAnnotationDeserializer() {
                return this.annotationDeserializer;
            }

            @Nullable
            public final FirModuleData getModuleData() {
                return this.moduleData;
            }

            @Nullable
            public final DeserializedContainerSource getSourceElement() {
                return this.sourceElement;
            }

            @NotNull
            public final FirTypeDeserializer.FlexibleTypeFactory getFlexibleTypeFactory() {
                return this.flexibleTypeFactory;
            }

            @NotNull
            public final NameResolver component1() {
                return this.nameResolver;
            }

            @NotNull
            public final ProtoBuf.Class component2() {
                return this.classProto;
            }

            @Nullable
            public final AbstractAnnotationDeserializer component3() {
                return this.annotationDeserializer;
            }

            @Nullable
            public final FirModuleData component4() {
                return this.moduleData;
            }

            @Nullable
            public final DeserializedContainerSource component5() {
                return this.sourceElement;
            }

            @NotNull
            public final FirTypeDeserializer.FlexibleTypeFactory component6() {
                return this.flexibleTypeFactory;
            }

            @NotNull
            public final Metadata copy(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto, @Nullable AbstractAnnotationDeserializer annotationDeserializer2, @Nullable FirModuleData moduleData2, @Nullable DeserializedContainerSource sourceElement, @NotNull FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory) {
                Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
                Intrinsics.checkNotNullParameter(classProto, "classProto");
                Intrinsics.checkNotNullParameter(flexibleTypeFactory, "flexibleTypeFactory");
                return new Metadata(nameResolver, classProto, annotationDeserializer2, moduleData2, sourceElement, flexibleTypeFactory);
            }

            public static /* synthetic */ Metadata copy$default(Metadata metadata2, NameResolver nameResolver, ProtoBuf.Class clazz, AbstractAnnotationDeserializer abstractAnnotationDeserializer, FirModuleData firModuleData, DeserializedContainerSource deserializedContainerSource, FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    nameResolver = metadata2.nameResolver;
                }
                if ((n2 & 2) != 0) {
                    clazz = metadata2.classProto;
                }
                if ((n2 & 4) != 0) {
                    abstractAnnotationDeserializer = metadata2.annotationDeserializer;
                }
                if ((n2 & 8) != 0) {
                    firModuleData = metadata2.moduleData;
                }
                if ((n2 & 0x10) != 0) {
                    deserializedContainerSource = metadata2.sourceElement;
                }
                if ((n2 & 0x20) != 0) {
                    flexibleTypeFactory = metadata2.flexibleTypeFactory;
                }
                return metadata2.copy(nameResolver, clazz, abstractAnnotationDeserializer, firModuleData, deserializedContainerSource, flexibleTypeFactory);
            }

            @NotNull
            public String toString() {
                return "Metadata(nameResolver=" + this.nameResolver + ", classProto=" + this.classProto + ", annotationDeserializer=" + this.annotationDeserializer + ", moduleData=" + this.moduleData + ", sourceElement=" + this.sourceElement + ", flexibleTypeFactory=" + this.flexibleTypeFactory + ')';
            }

            public int hashCode() {
                int result2 = this.nameResolver.hashCode();
                result2 = result2 * 31 + this.classProto.hashCode();
                result2 = result2 * 31 + (this.annotationDeserializer == null ? 0 : this.annotationDeserializer.hashCode());
                result2 = result2 * 31 + (this.moduleData == null ? 0 : this.moduleData.hashCode());
                result2 = result2 * 31 + (this.sourceElement == null ? 0 : this.sourceElement.hashCode());
                result2 = result2 * 31 + this.flexibleTypeFactory.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Metadata)) {
                    return false;
                }
                Metadata metadata2 = (Metadata)other;
                if (!Intrinsics.areEqual(this.nameResolver, metadata2.nameResolver)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.classProto, metadata2.classProto)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.annotationDeserializer, metadata2.annotationDeserializer)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.moduleData, metadata2.moduleData)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.sourceElement, metadata2.sourceElement)) {
                    return false;
                }
                return Intrinsics.areEqual(this.flexibleTypeFactory, metadata2.flexibleTypeFactory);
            }
        }

        @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006H\u00c6\u0003J#\u0010\f\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult$NoMetadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "classPostProcessor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "Lorg/jetbrains/kotlin/fir/deserialization/DeserializedClassPostProcessor;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getClassPostProcessor", "()Lkotlin/jvm/functions/Function1;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fir-deserialization"})
        public static final class NoMetadata
        extends ClassMetadataFindResult {
            @NotNull
            private final Function1<FirRegularClassSymbol, Unit> classPostProcessor;

            public NoMetadata(@NotNull Function1<? super FirRegularClassSymbol, Unit> classPostProcessor) {
                Intrinsics.checkNotNullParameter(classPostProcessor, "classPostProcessor");
                super(null);
                this.classPostProcessor = classPostProcessor;
            }

            @NotNull
            public final Function1<FirRegularClassSymbol, Unit> getClassPostProcessor() {
                return this.classPostProcessor;
            }

            @NotNull
            public final Function1<FirRegularClassSymbol, Unit> component1() {
                return this.classPostProcessor;
            }

            @NotNull
            public final NoMetadata copy(@NotNull Function1<? super FirRegularClassSymbol, Unit> classPostProcessor) {
                Intrinsics.checkNotNullParameter(classPostProcessor, "classPostProcessor");
                return new NoMetadata(classPostProcessor);
            }

            public static /* synthetic */ NoMetadata copy$default(NoMetadata noMetadata, Function1 function1, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    function1 = noMetadata.classPostProcessor;
                }
                return noMetadata.copy(function1);
            }

            @NotNull
            public String toString() {
                return "NoMetadata(classPostProcessor=" + this.classPostProcessor + ')';
            }

            public int hashCode() {
                return this.classPostProcessor.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoMetadata)) {
                    return false;
                }
                NoMetadata noMetadata = (NoMetadata)other;
                return Intrinsics.areEqual(this.classPostProcessor, noMetadata.classPostProcessor);
            }
        }
    }
}

