/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native.interop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt$isExternalObjCClass$;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

public final class FirObjCInteropKt {
    @Nullable
    public static final ObjCMethodInfo getObjCMethodInfoFromOverriddenFunctions(@NotNull FirFunctionSymbol<?> $this$getObjCMethodInfoFromOverriddenFunctions, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        ObjCMethodInfo objCMethodInfo;
        block7: {
            Intrinsics.checkNotNullParameter($this$getObjCMethodInfoFromOverriddenFunctions, "<this>");
            Intrinsics.checkNotNullParameter(session, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            ObjCMethodInfo objCMethodInfo2 = FirObjCInteropKt.decodeObjCMethodAnnotation($this$getObjCMethodInfoFromOverriddenFunctions, session);
            if (objCMethodInfo2 != null) {
                ObjCMethodInfo it = objCMethodInfo2;
                boolean bl = false;
                return it;
            }
            FirFunctionSymbol<?> symbol = $this$getObjCMethodInfoFromOverriddenFunctions;
            if (symbol instanceof FirNamedFunctionSymbol) {
                FirClassSymbol firClassSymbol;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)$this$getObjCMethodInfoFromOverriddenFunctions);
                FirClassSymbol firClassSymbol2 = firClassSymbol = (FirClassSymbol)(coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, session) : null);
                if (firClassSymbol2 != null) {
                    FirClassSymbol it = firClassSymbol2;
                    boolean bl = false;
                    FirTypeScope unsubstitutedScope = FirKotlinScopeProviderKt.unsubstitutedScope(it, session, scopeSession, false, null);
                    for (FirNamedFunctionSymbol it2 : (Iterable)FirTypeScopeKt.getDirectOverriddenSafe(unsubstitutedScope, (FirNamedFunctionSymbol)symbol)) {
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(it2, $this$getObjCMethodInfoFromOverriddenFunctions))) {
                            boolean bl3 = false;
                            String string = "Function " + ((FirNamedFunctionSymbol)symbol).getName() + "() is wrongly contained in its own getDirectOverriddenFunctions";
                            throw new IllegalArgumentException(string.toString());
                        }
                        ObjCMethodInfo objCMethodInfo3 = FirObjCInteropKt.getObjCMethodInfoFromOverriddenFunctions(it2, session, scopeSession);
                        if (objCMethodInfo3 == null) continue;
                        objCMethodInfo = objCMethodInfo3;
                        break block7;
                    }
                    objCMethodInfo = null;
                } else {
                    objCMethodInfo = null;
                }
            } else {
                objCMethodInfo = null;
            }
        }
        return objCMethodInfo;
    }

    @Nullable
    public static final FirFunctionSymbol<?> getObjCInitMethod(@NotNull FirConstructorSymbol $this$getObjCInitMethod, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$getObjCInitMethod, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getObjCInitMethod.getResolvedAnnotationsWithClassIds(), NativeStandardInteropNames.INSTANCE.getObjCConstructorClassId(), session);
        if (firAnnotation != null) {
            FirAnnotation annotation = firAnnotation;
            boolean bl = false;
            String initSelector = FirObjCInteropKt.constStringArgument(annotation, "initSelector");
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$getObjCInitMethod);
            FirClassLikeSymbol<Object> firClassLikeSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, session) : null;
            Intrinsics.checkNotNull(firClassLikeSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol<*>");
            FirClassSymbol classSymbol = (FirClassSymbol)firClassLikeSymbol;
            List initSelectors = new ArrayList();
            FirContainingNamesAwareScopeKt.processAllFunctions(FirDeclaredMemberScopeProviderKt.declaredMemberScope(session, classSymbol, null), arg_0 -> FirObjCInteropKt.getObjCInitMethod$lambda$5$lambda$4(session, initSelector, initSelectors, arg_0));
            FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)CollectionsKt.singleOrNull(initSelectors);
            if (firFunctionSymbol == null) {
                throw new IllegalStateException(("expected one init method for " + classSymbol + ' ' + initSelector + ", got " + initSelectors.size()).toString());
            }
            return firFunctionSymbol;
        }
        return null;
    }

    @Nullable
    public static final ObjCMethodInfo decodeObjCMethodAnnotation(@NotNull List<? extends FirAnnotation> $this$decodeObjCMethodAnnotation, @NotNull FirSession session) {
        ObjCMethodInfo objCMethodInfo;
        Intrinsics.checkNotNullParameter($this$decodeObjCMethodAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$decodeObjCMethodAnnotation, NativeStandardInteropNames.INSTANCE.getObjCMethodClassId(), session);
        if (firAnnotation != null) {
            FirAnnotation it = firAnnotation;
            boolean bl = false;
            Boolean bl2 = FirObjCInteropKt.constBooleanArgumentOrNull(it, "isStret");
            FirAnnotation firAnnotation2 = FirAnnotationUtilsKt.getAnnotationByClassId($this$decodeObjCMethodAnnotation, NativeStandardInteropNames.INSTANCE.getObjCDirectClassId(), session);
            objCMethodInfo = new ObjCMethodInfo(FirObjCInteropKt.constStringArgument(it, "selector"), FirObjCInteropKt.constStringArgument(it, "encoding"), bl2 != null ? bl2 : false, firAnnotation2 != null ? FirObjCInteropKt.constStringArgument(firAnnotation2, "symbol") : null);
        } else {
            objCMethodInfo = null;
        }
        return objCMethodInfo;
    }

    @Nullable
    public static final ObjCMethodInfo decodeObjCMethodAnnotation(@NotNull FirFunctionSymbol<?> $this$decodeObjCMethodAnnotation, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$decodeObjCMethodAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirObjCInteropKt.decodeObjCMethodAnnotation($this$decodeObjCMethodAnnotation.getResolvedAnnotationsWithClassIds(), session);
    }

    private static final String constStringArgument(FirAnnotation $this$constStringArgument, String argumentName) {
        Object object = FirObjCInteropKt.constArgument($this$constStringArgument, argumentName);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            throw new IllegalStateException(("Expected string constant value of argument '" + argumentName + "' at annotation " + $this$constStringArgument).toString());
        }
        return string;
    }

    private static final Boolean constBooleanArgumentOrNull(FirAnnotation $this$constBooleanArgumentOrNull, String argumentName) {
        return (Boolean)FirObjCInteropKt.constArgument($this$constBooleanArgumentOrNull, argumentName);
    }

    private static final Object constArgument(FirAnnotation $this$constArgument, String argumentName) {
        FirExpression firExpression = $this$constArgument.getArgumentMapping().getMapping().get(Name.identifier(argumentName));
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        return firLiteralExpression != null ? firLiteralExpression.getValue() : null;
    }

    public static final boolean isObjCClass(@NotNull FirClassSymbol<?> $this$isObjCClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isObjCClass, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return !Intrinsics.areEqual($this$isObjCClass.getClassId().getPackageFqName(), NativeStandardInteropNames.INSTANCE.getCInteropPackage()) && FirObjCInteropKt.selfOrAnySuperClass($this$isObjCClass, session, FirObjCInteropKt::isObjCClass$lambda$8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean selfOrAnySuperClass(FirClassSymbol<?> $this$selfOrAnySuperClass, FirSession session, Function1<? super ConeClassLikeLookupTag, Boolean> predicate) {
        ConeClassLikeType it;
        if (predicate.invoke($this$selfOrAnySuperClass.toLookupTag()) != false) return true;
        Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default(CollectionsKt.listOf($this$selfOrAnySuperClass), true, true, session, false, null, 32, null);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ConeClassLikeType)element$iv;
            boolean bl = false;
        } while (!predicate.invoke(it.getLookupTag()).booleanValue());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExternalObjCClass(@NotNull FirClassSymbol<?> $this$isExternalObjCClass, @NotNull FirSession session) {
        FirClassSymbol it;
        Intrinsics.checkNotNullParameter($this$isExternalObjCClass, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!FirObjCInteropKt.isObjCClass($this$isExternalObjCClass, session)) return false;
        Sequence<FirClassLikeSymbol<FirClassLikeDeclaration>> $this$filterIsInstance$iv = FirObjCInteropKt.parentsWithSelf($this$isExternalObjCClass, session);
        boolean $i$f$filterIsInstance = false;
        Sequence<FirClassLikeSymbol<FirClassLikeDeclaration>> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, isExternalObjCClass$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence<FirClassLikeSymbol<FirClassLikeDeclaration>> $this$any$iv = sequence2;
        boolean $i$f$any = false;
        Iterator<FirClassLikeSymbol<FirClassLikeDeclaration>> iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            FirClassLikeSymbol<FirClassLikeDeclaration> element$iv = iterator2.next();
            it = (FirClassSymbol)element$iv;
            boolean bl = false;
        } while (!FirAnnotationUtilsKt.hasAnnotation(it, NativeStandardInteropNames.INSTANCE.getExternalObjCClassClassId(), session));
        return true;
    }

    @NotNull
    public static final Sequence<FirClassLikeSymbol<FirClassLikeDeclaration>> parentsWithSelf(@NotNull FirClassSymbol<?> $this$parentsWithSelf, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$parentsWithSelf, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return SequencesKt.generateSequence($this$parentsWithSelf, arg_0 -> FirObjCInteropKt.parentsWithSelf$lambda$11(session, arg_0));
    }

    public static final boolean isKotlinObjCClass(@NotNull FirClassSymbol<?> $this$isKotlinObjCClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isKotlinObjCClass, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirObjCInteropKt.isObjCClass($this$isKotlinObjCClass, session) && !FirObjCInteropKt.isExternalObjCClass($this$isKotlinObjCClass, session);
    }

    public static final boolean isObjCObjectType(@NotNull FirTypeRef $this$isObjCObjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isObjCObjectType, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirClassLikeDeclaration firClassLikeDeclaration = DeclarationUtilsKt.firClassLike($this$isObjCObjectType, session);
        FirClassLikeSymbol<FirClassLikeDeclaration> symbol = firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
        return symbol instanceof FirClassSymbol && FirObjCInteropKt.isObjCClass((FirClassSymbol)symbol, session);
    }

    private static final Unit getObjCInitMethod$lambda$5$lambda$4(FirSession $session, String $initSelector, List $initSelectors, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ObjCMethodInfo objCMethodInfo = FirObjCInteropKt.decodeObjCMethodAnnotation(it, $session);
        if (Intrinsics.areEqual(objCMethodInfo != null ? objCMethodInfo.getSelector() : null, $initSelector)) {
            $initSelectors.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean isObjCClass$lambda$8(ConeClassLikeLookupTag it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getClassId(), NativeStandardInteropNames.INSTANCE.getObjCObjectClassId());
    }

    private static final FirClassLikeSymbol parentsWithSelf$lambda$11(FirSession $session, FirClassLikeSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DeclarationUtilsKt.getContainingDeclaration(it, $session);
    }
}

