/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.impl.FirOverrideUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

public final class FirNativeOverrideChecker
implements FirOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirStandardOverrideChecker standardOverrideChecker;

    public FirNativeOverrideChecker(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.standardOverrideChecker = new FirStandardOverrideChecker(this.session);
    }

    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
        Boolean bl = this.isPlatformOverriddenFunction(overrideCandidate, this.session, baseDeclaration);
        return bl != null ? bl.booleanValue() : this.standardOverrideChecker.isOverriddenFunction(overrideCandidate, baseDeclaration);
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
        return this.standardOverrideChecker.isOverriddenProperty(overrideCandidate, baseDeclaration);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Visibility chooseIntersectionVisibility(@NotNull Collection<? extends FirCallableSymbol<?>> overrides, @Nullable FirRegularClassSymbol dispatchClassSymbol) {
        block9: {
            Intrinsics.checkNotNullParameter(overrides, "overrides");
            $i$f$chooseIntersectionVisibilityOrNull = false;
            $i$f$chooseIntersectionVisibilityOrNull = false;
            $this$filter$iv$iv$iv = overrides;
            $i$f$filter = false;
            var7_9 = $this$filter$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var10_15 = $this$filterTo$iv$iv$iv$iv.iterator();
            while (var10_15.hasNext()) {
                it$iv$iv = element$iv$iv$iv$iv = var10_15.next();
                $i$a$-filter-FirOverrideUtilsKt$chooseIntersectionVisibilityOrNull$nonAbstractOverrides$1$iv$iv = false;
                it = (FirCallableSymbol)it$iv$iv;
                $i$a$-chooseIntersectionVisibilityOrNull-FirNativeOverrideChecker$chooseIntersectionVisibility$1 = false;
                if (FirOverrideUtilsKt.isAbstractAccordingToRawStatus(it) != false || this.isObjCClassPropertyOrAccessor(it, this.session) != false) ** GOTO lbl-1000
                it$iv = (FirCallableSymbol)it$iv$iv;
                $i$a$-chooseIntersectionVisibilityOrNull-FirOverrideUtilsKt$chooseIntersectionVisibilityOrNull$2$iv = false;
                if (!Intrinsics.areEqual(it$iv.getCallableId(), StandardClassIds.Callables.INSTANCE.getClone())) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            nonAbstractOverrides$iv$iv = (List)destination$iv$iv$iv$iv;
            allAreAbstract$iv$iv = nonAbstractOverrides$iv$iv.isEmpty();
            if (allAreAbstract$iv$iv) {
                $i$f$findMaxVisibilityOrNull = false;
                maxVisibility$iv$iv$iv = Visibilities.Private.INSTANCE;
                for (E override$iv$iv$iv : overrides) {
                    it$iv = (FirCallableSymbol)override$iv$iv$iv;
                    $i$a$-chooseIntersectionVisibilityOrNull-FirOverrideUtilsKt$chooseIntersectionVisibilityOrNull$2$iv = false;
                    v1 = it$iv.getFir();
                    Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
                    $this$visibility$iv$iv$iv$iv = (FirMemberDeclaration)v1;
                    $i$f$getVisibility = false;
                    visibility$iv$iv$iv = $this$visibility$iv$iv$iv$iv.getStatus().getVisibility();
                    v2 = Visibilities.INSTANCE.compare(visibility$iv$iv$iv, (Visibility)maxVisibility$iv$iv$iv);
                    if (v2 == null) {
                        v3 = null;
                        break block9;
                    }
                    compare$iv$iv$iv = v2;
                    if (compare$iv$iv$iv <= 0) continue;
                    maxVisibility$iv$iv$iv = visibility$iv$iv$iv;
                }
                v3 = maxVisibility$iv$iv$iv;
            } else {
                $i$f$findMaxVisibilityOrNull = nonAbstractOverrides$iv$iv;
                maxVisibility$iv$iv$iv = new LinkedHashSet<E>();
                $i$f$mapTo = false;
                var9_14 = $this$mapTo$iv$iv$iv.iterator();
                while (var9_14.hasNext()) {
                    $i$f$getVisibility = item$iv$iv$iv = var9_14.next();
                    var16_24 = destination$iv$iv$iv;
                    $i$a$-mapTo-FirOverrideUtilsKt$chooseIntersectionVisibilityOrNull$3$iv$iv = false;
                    it$iv = (FirCallableSymbol)it$iv$iv;
                    $i$a$-chooseIntersectionVisibilityOrNull-FirOverrideUtilsKt$chooseIntersectionVisibilityOrNull$2$iv = false;
                    var16_24.add(it$iv.getRawStatus().getVisibility());
                }
                v3 = (Visibility)CollectionsKt.singleOrNull((Iterable)destination$iv$iv$iv);
            }
        }
        v4 = v3;
        if (v3 == null) {
            v4 = Visibilities.Unknown.INSTANCE;
        }
        return v4;
    }

    private final boolean isObjCClassPropertyOrAccessor(FirCallableSymbol<?> $this$isObjCClassPropertyOrAccessor, FirSession session) {
        Object object;
        return ($this$isObjCClassPropertyOrAccessor instanceof FirPropertySymbol || $this$isObjCClassPropertyOrAccessor instanceof FirPropertyAccessorSymbol) && ((object = ClassMembersKt.containingClassLookupTag($this$isObjCClassPropertyOrAccessor)) != null && (object = ToSymbolUtilsKt.toClassSymbol((ConeClassLikeLookupTag)object, session)) != null ? FirObjCInteropKt.isObjCClass(object, session) : false);
    }

    private final Boolean isPlatformOverriddenFunction(FirSimpleFunction $this$isPlatformOverriddenFunction, FirSession session, FirSimpleFunction baseDeclaration) {
        if (!Intrinsics.areEqual($this$isPlatformOverriddenFunction.getName(), baseDeclaration.getName())) {
            return null;
        }
        ObjCMethodInfo objCMethodInfo = FirObjCInteropKt.decodeObjCMethodAnnotation(baseDeclaration.getSymbol(), session);
        if (objCMethodInfo == null) {
            return null;
        }
        ObjCMethodInfo superInfo = objCMethodInfo;
        ObjCMethodInfo subInfo = FirObjCInteropKt.decodeObjCMethodAnnotation($this$isPlatformOverriddenFunction.getSymbol(), session);
        return subInfo != null ? Boolean.valueOf(Intrinsics.areEqual(superInfo.getSelector(), subInfo.getSelector())) : (!this.parameterNamesMatch($this$isPlatformOverriddenFunction, baseDeclaration) ? Boolean.valueOf(false) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parameterNamesMatch(FirSimpleFunction first2, FirSimpleFunction second2) {
        if (first2.getValueParameters().size() != second2.getValueParameters().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = first2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = n2;
            boolean bl = false;
            if (index2 <= 0 || Intrinsics.areEqual(parameter.getName(), second2.getValueParameters().get(index2).getName())) continue;
            return false;
        }
        return true;
    }
}

