/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapper;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.NativeRuntimeNames;

public final class FirNativeClassMapper
extends FirPlatformClassMapper {
    @NotNull
    private final Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity;

    public FirNativeClassMapper() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(NativeRuntimeNames.Annotations.INSTANCE.getThrows(), NativeRuntimeNames.Annotations.INSTANCE.getThrowsAlias()), TuplesKt.to(NativeRuntimeNames.Annotations.INSTANCE.getSharedImmutable(), NativeRuntimeNames.Annotations.INSTANCE.getSharedImmutableAlias()), TuplesKt.to(NativeRuntimeNames.Annotations.INSTANCE.getThreadLocal(), NativeRuntimeNames.Annotations.INSTANCE.getThreadLocalAlias())};
        this.classTypealiasesThatDontCauseAmbiguity = MapsKt.mapOf(pairArray);
    }

    @Override
    @Nullable
    public FirRegularClass getCorrespondingPlatformClass(@NotNull FirClassLikeDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return null;
    }

    @Override
    @Nullable
    public ClassId getCorrespondingPlatformClass(@Nullable ClassId classId) {
        return null;
    }

    @Override
    @Nullable
    public ClassId getCorrespondingKotlinClass(@Nullable ClassId classId) {
        return null;
    }

    @Override
    @NotNull
    public Map<ClassId, ClassId> getClassTypealiasesThatDontCauseAmbiguity() {
        return this.classTypealiasesThatDontCauseAmbiguity;
    }
}

