/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeErrorLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContextForTypeMapping;
import org.jetbrains.kotlin.types.model.AnnotationMarker;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.CapturedTypeConstructorMarker;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;
import org.jetbrains.kotlin.types.model.DynamicTypeMarker;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeVariance;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConeTypeSystemCommonBackendContextForTypeMapping
implements TypeSystemCommonBackendContextForTypeMapping {
    @NotNull
    private final ConeTypeContext context;
    @NotNull
    private final Function1<String, String> unresolvedQualifierRemapper;
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public ConeTypeSystemCommonBackendContextForTypeMapping(@NotNull ConeTypeContext context, @NotNull Function1<? super String, String> unresolvedQualifierRemapper) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(unresolvedQualifierRemapper, "unresolvedQualifierRemapper");
        this.context = context;
        this.unresolvedQualifierRemapper = unresolvedQualifierRemapper;
        this.session = this.context.getSession();
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
    }

    @Override
    public boolean isTypeParameter(@NotNull TypeConstructorMarker $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "<this>");
        return $this$isTypeParameter instanceof ConeTypeParameterLookupTag;
    }

    @Override
    @NotNull
    public TypeParameterMarker asTypeParameter(@NotNull TypeConstructorMarker $this$asTypeParameter) {
        Intrinsics.checkNotNullParameter($this$asTypeParameter, "<this>");
        if (!this.isTypeParameter($this$asTypeParameter)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (ConeTypeParameterLookupTag)$this$asTypeParameter;
    }

    @Override
    @NotNull
    public ConeSimpleKotlinType defaultType(@NotNull TypeConstructorMarker $this$defaultType) {
        ConeSimpleKotlinType coneSimpleKotlinType;
        Intrinsics.checkNotNullParameter($this$defaultType, "<this>");
        if (!($this$defaultType instanceof ConeClassifierLookupTag)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ConeClassifierLookupTag coneClassifierLookupTag = (ConeClassifierLookupTag)$this$defaultType;
        if (coneClassifierLookupTag instanceof ConeTypeParameterLookupTag) {
            coneSimpleKotlinType = new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)$this$defaultType, false, null, 4, null);
        } else if (coneClassifierLookupTag instanceof ConeClassLikeLookupTag) {
            FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol((ConeClassLikeLookupTag)$this$defaultType, this.session);
            if (firClassSymbol == null) {
                return new ConeErrorType(new ConeUnresolvedSymbolError(((ConeClassLikeLookupTag)$this$defaultType).getClassId()), false, null, null, null, null, null, 126, null);
            }
            FirClassSymbol<?> symbol = firClassSymbol;
            coneSimpleKotlinType = ScopeUtilsKt.defaultType((FirClassLikeDeclaration)symbol.getFir());
        } else {
            throw new IllegalStateException(("Unsupported type constructor: " + $this$defaultType).toString());
        }
        return coneSimpleKotlinType;
    }

    @Override
    public boolean isScript(@NotNull TypeConstructorMarker $this$isScript) {
        Intrinsics.checkNotNullParameter($this$isScript, "<this>");
        return false;
    }

    @Override
    public boolean isSuspendFunction(@NotNull RigidTypeMarker $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunction, "<this>");
        if (!($this$isSuspendFunction instanceof ConeRigidType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType((ConeKotlinType)((Object)$this$isSuspendFunction), this.session);
    }

    @Override
    public boolean isKClass(@NotNull RigidTypeMarker $this$isKClass) {
        Intrinsics.checkNotNullParameter($this$isKClass, "<this>");
        if (!($this$isKClass instanceof ConeRigidType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return InferenceUtilsKt.isKClassType((ConeKotlinType)((Object)$this$isKClass));
    }

    @Override
    public boolean isRawType(@NotNull KotlinTypeMarker $this$isRawType) {
        Intrinsics.checkNotNullParameter($this$isRawType, "<this>");
        return $this$isRawType instanceof ConeRawType;
    }

    @Override
    @NotNull
    public ConeSimpleKotlinType typeWithArguments(@NotNull TypeConstructorMarker $this$typeWithArguments, @NotNull List<? extends KotlinTypeMarker> arguments2) {
        Intrinsics.checkNotNullParameter($this$typeWithArguments, "<this>");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Iterable $this$forEach$iv = arguments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinTypeMarker it = (KotlinTypeMarker)element$iv;
            boolean bl = false;
            if (it instanceof ConeKotlinType) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Collection $this$toTypedArray$iv = arguments2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (ConeSimpleKotlinType)TypeUtilsKt.withArguments((ConeKotlinType)this.defaultType($this$typeWithArguments), thisCollection$iv.toArray(new ConeKotlinType[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConeKotlinType representativeUpperBound(@NotNull TypeParameterMarker $this$representativeUpperBound) {
        ConeKotlinType coneKotlinType;
        Object v0;
        List bounds;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$representativeUpperBound, "<this>");
            if (!($this$representativeUpperBound instanceof ConeTypeParameterLookupTag)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterable $this$map$iv = ((ConeTypeParameterLookupTag)$this$representativeUpperBound).getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getConeType());
            }
            bounds = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = bounds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirRegularClassSymbol classSymbol;
                ClassKind kind;
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                if (!(ToSymbolUtilsKt.toRegularClassSymbol(it, this.session) == null ? false : (kind = ((FirRegularClass)classSymbol.getFir()).getClassKind()) != ClassKind.INTERFACE && kind != ClassKind.ANNOTATION_CLASS)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((coneKotlinType = (ConeKotlinType)v0) == null) {
            coneKotlinType = (ConeKotlinType)CollectionsKt.first(bounds);
        }
        return coneKotlinType;
    }

    @Override
    @NotNull
    public ConeClassLikeLookupTag continuationTypeConstructor() {
        return this.possiblyErrorTypeConstructorByClassId(StandardClassIds.INSTANCE.getContinuation());
    }

    @Override
    @NotNull
    public TypeConstructorMarker functionNTypeConstructor(int n2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId(StandardClassIds.INSTANCE.FunctionN(n2));
        if (firClassLikeSymbol == null || (firClassLikeSymbol = firClassLikeSymbol.toLookupTag()) == null) {
            throw new IllegalStateException(("Function" + n2 + " class not found").toString());
        }
        return (TypeConstructorMarker)((Object)firClassLikeSymbol);
    }

    private final ConeClassLikeLookupTag possiblyErrorTypeConstructorByClassId(ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null || (firClassLikeSymbol = firClassLikeSymbol.toLookupTag()) == null) {
            firClassLikeSymbol = new ConeClassLikeErrorLookupTag(classId, new ConeUnresolvedSymbolError(classId), null, 4, null);
        }
        return firClassLikeSymbol;
    }

    @Override
    @Nullable
    public String getNameForErrorType(@NotNull KotlinTypeMarker $this$getNameForErrorType) {
        String string;
        String result2;
        Intrinsics.checkNotNullParameter($this$getNameForErrorType, "<this>");
        if (!($this$getNameForErrorType instanceof ConeErrorType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeDiagnostic diagnostic = ((ConeErrorType)$this$getNameForErrorType).getDiagnostic();
        String string3 = result2 = diagnostic instanceof ConeUnresolvedTypeQualifierError ? ((ConeUnresolvedTypeQualifierError)diagnostic).getQualifier() : null;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string = this.unresolvedQualifierRemapper.invoke(it);
            if (string == null) {
                string = it;
            }
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public SimpleTypeMarker nullableAnyType() {
        return this.context.nullableAnyType();
    }

    @Override
    @NotNull
    public SimpleTypeMarker arrayType(@NotNull KotlinTypeMarker componentType) {
        Intrinsics.checkNotNullParameter(componentType, "componentType");
        return this.context.arrayType(componentType);
    }

    @Override
    public boolean isArrayOrNullableArray(@NotNull KotlinTypeMarker $this$isArrayOrNullableArray) {
        Intrinsics.checkNotNullParameter($this$isArrayOrNullableArray, "<this>");
        return this.context.isArrayOrNullableArray($this$isArrayOrNullableArray);
    }

    @Override
    public boolean isFinalClassOrEnumEntryOrAnnotationClassConstructor(@NotNull TypeConstructorMarker $this$isFinalClassOrEnumEntryOrAnnotationClassConstructor) {
        Intrinsics.checkNotNullParameter($this$isFinalClassOrEnumEntryOrAnnotationClassConstructor, "<this>");
        return this.context.isFinalClassOrEnumEntryOrAnnotationClassConstructor($this$isFinalClassOrEnumEntryOrAnnotationClassConstructor);
    }

    @Override
    public boolean hasAnnotation(@NotNull KotlinTypeMarker $this$hasAnnotation, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter($this$hasAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.context.hasAnnotation($this$hasAnnotation, fqName2);
    }

    @Override
    @Nullable
    public Object getAnnotationFirstArgumentValue(@NotNull KotlinTypeMarker $this$getAnnotationFirstArgumentValue, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter($this$getAnnotationFirstArgumentValue, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.context.getAnnotationFirstArgumentValue($this$getAnnotationFirstArgumentValue, fqName2);
    }

    @Override
    public boolean isInlineClass(@NotNull TypeConstructorMarker $this$isInlineClass) {
        Intrinsics.checkNotNullParameter($this$isInlineClass, "<this>");
        return this.context.isInlineClass($this$isInlineClass);
    }

    @Override
    public boolean isMultiFieldValueClass(@NotNull TypeConstructorMarker $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter($this$isMultiFieldValueClass, "<this>");
        return this.context.isMultiFieldValueClass($this$isMultiFieldValueClass);
    }

    @Override
    @Nullable
    public List<Pair<Name, RigidTypeMarker>> getValueClassProperties(@NotNull TypeConstructorMarker $this$getValueClassProperties) {
        Intrinsics.checkNotNullParameter($this$getValueClassProperties, "<this>");
        return this.context.getValueClassProperties($this$getValueClassProperties);
    }

    @Override
    public boolean isInnerClass(@NotNull TypeConstructorMarker $this$isInnerClass) {
        Intrinsics.checkNotNullParameter($this$isInnerClass, "<this>");
        return this.context.isInnerClass($this$isInnerClass);
    }

    @Override
    @NotNull
    public KotlinTypeMarker getRepresentativeUpperBound(@NotNull TypeParameterMarker $this$getRepresentativeUpperBound) {
        Intrinsics.checkNotNullParameter($this$getRepresentativeUpperBound, "<this>");
        return this.context.getRepresentativeUpperBound($this$getRepresentativeUpperBound);
    }

    @Override
    @Nullable
    public KotlinTypeMarker getUnsubstitutedUnderlyingType(@NotNull KotlinTypeMarker $this$getUnsubstitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter($this$getUnsubstitutedUnderlyingType, "<this>");
        return this.context.getUnsubstitutedUnderlyingType($this$getUnsubstitutedUnderlyingType);
    }

    @Override
    @Nullable
    public KotlinTypeMarker getSubstitutedUnderlyingType(@NotNull KotlinTypeMarker $this$getSubstitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter($this$getSubstitutedUnderlyingType, "<this>");
        return this.context.getSubstitutedUnderlyingType($this$getSubstitutedUnderlyingType);
    }

    @Override
    @NotNull
    public KotlinTypeMarker makeNullable(@NotNull KotlinTypeMarker $this$makeNullable) {
        Intrinsics.checkNotNullParameter($this$makeNullable, "<this>");
        return this.context.makeNullable($this$makeNullable);
    }

    @Override
    @Nullable
    public PrimitiveType getPrimitiveType(@NotNull TypeConstructorMarker $this$getPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveType, "<this>");
        return this.context.getPrimitiveType($this$getPrimitiveType);
    }

    @Override
    @Nullable
    public PrimitiveType getPrimitiveArrayType(@NotNull TypeConstructorMarker $this$getPrimitiveArrayType) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveArrayType, "<this>");
        return this.context.getPrimitiveArrayType($this$getPrimitiveArrayType);
    }

    @Override
    public boolean isUnderKotlinPackage(@NotNull TypeConstructorMarker $this$isUnderKotlinPackage) {
        Intrinsics.checkNotNullParameter($this$isUnderKotlinPackage, "<this>");
        return this.context.isUnderKotlinPackage($this$isUnderKotlinPackage);
    }

    @Override
    @Nullable
    public FqNameUnsafe getClassFqNameUnsafe(@NotNull TypeConstructorMarker $this$getClassFqNameUnsafe) {
        Intrinsics.checkNotNullParameter($this$getClassFqNameUnsafe, "<this>");
        return this.context.getClassFqNameUnsafe($this$getClassFqNameUnsafe);
    }

    @Override
    @NotNull
    public Name getName(@NotNull TypeParameterMarker $this$getName) {
        Intrinsics.checkNotNullParameter($this$getName, "<this>");
        return this.context.getName($this$getName);
    }

    @Override
    public boolean isReified(@NotNull TypeParameterMarker $this$isReified) {
        Intrinsics.checkNotNullParameter($this$isReified, "<this>");
        return this.context.isReified($this$isReified);
    }

    @Override
    public boolean isInterfaceOrAnnotationClass(@NotNull KotlinTypeMarker $this$isInterfaceOrAnnotationClass) {
        Intrinsics.checkNotNullParameter($this$isInterfaceOrAnnotationClass, "<this>");
        return this.context.isInterfaceOrAnnotationClass($this$isInterfaceOrAnnotationClass);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public RigidTypeMarker asRigidType(@NotNull RigidTypeMarker $this$asRigidType) {
        Intrinsics.checkNotNullParameter($this$asRigidType, "<this>");
        return this.context.asRigidType($this$asRigidType);
    }

    @Override
    @Nullable
    public RigidTypeMarker asRigidType(@NotNull KotlinTypeMarker $this$asRigidType) {
        Intrinsics.checkNotNullParameter($this$asRigidType, "<this>");
        return this.context.asRigidType($this$asRigidType);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public FlexibleTypeMarker asFlexibleType(@NotNull FlexibleTypeMarker $this$asFlexibleType) {
        Intrinsics.checkNotNullParameter($this$asFlexibleType, "<this>");
        return this.context.asFlexibleType($this$asFlexibleType);
    }

    @Override
    @Nullable
    public FlexibleTypeMarker asFlexibleType(@NotNull KotlinTypeMarker $this$asFlexibleType) {
        Intrinsics.checkNotNullParameter($this$asFlexibleType, "<this>");
        return this.context.asFlexibleType($this$asFlexibleType);
    }

    @Override
    public boolean isError(@NotNull KotlinTypeMarker $this$isError) {
        Intrinsics.checkNotNullParameter($this$isError, "<this>");
        return this.context.isError($this$isError);
    }

    @Override
    public boolean isError(@NotNull TypeConstructorMarker $this$isError) {
        Intrinsics.checkNotNullParameter($this$isError, "<this>");
        return this.context.isError($this$isError);
    }

    @Override
    public boolean isUninferredParameter(@NotNull KotlinTypeMarker $this$isUninferredParameter) {
        Intrinsics.checkNotNullParameter($this$isUninferredParameter, "<this>");
        return this.context.isUninferredParameter($this$isUninferredParameter);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public DynamicTypeMarker asDynamicType(@NotNull DynamicTypeMarker $this$asDynamicType) {
        Intrinsics.checkNotNullParameter($this$asDynamicType, "<this>");
        return this.context.asDynamicType($this$asDynamicType);
    }

    @Override
    @Nullable
    public DynamicTypeMarker asDynamicType(@NotNull FlexibleTypeMarker $this$asDynamicType) {
        Intrinsics.checkNotNullParameter($this$asDynamicType, "<this>");
        return this.context.asDynamicType($this$asDynamicType);
    }

    @Override
    @NotNull
    public RigidTypeMarker upperBound(@NotNull FlexibleTypeMarker $this$upperBound) {
        Intrinsics.checkNotNullParameter($this$upperBound, "<this>");
        return this.context.upperBound($this$upperBound);
    }

    @Override
    @NotNull
    public RigidTypeMarker lowerBound(@NotNull FlexibleTypeMarker $this$lowerBound) {
        Intrinsics.checkNotNullParameter($this$lowerBound, "<this>");
        return this.context.lowerBound($this$lowerBound);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public CapturedTypeMarker asCapturedType(@NotNull CapturedTypeMarker $this$asCapturedType) {
        Intrinsics.checkNotNullParameter($this$asCapturedType, "<this>");
        return this.context.asCapturedType($this$asCapturedType);
    }

    @Override
    @Nullable
    public CapturedTypeMarker asCapturedType(@NotNull SimpleTypeMarker $this$asCapturedType) {
        Intrinsics.checkNotNullParameter($this$asCapturedType, "<this>");
        return this.context.asCapturedType($this$asCapturedType);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public CapturedTypeMarker asCapturedTypeUnwrappingDnn(@NotNull CapturedTypeMarker $this$asCapturedTypeUnwrappingDnn) {
        Intrinsics.checkNotNullParameter($this$asCapturedTypeUnwrappingDnn, "<this>");
        return this.context.asCapturedTypeUnwrappingDnn($this$asCapturedTypeUnwrappingDnn);
    }

    @Override
    @Nullable
    public CapturedTypeMarker asCapturedTypeUnwrappingDnn(@NotNull RigidTypeMarker $this$asCapturedTypeUnwrappingDnn) {
        Intrinsics.checkNotNullParameter($this$asCapturedTypeUnwrappingDnn, "<this>");
        return this.context.asCapturedTypeUnwrappingDnn($this$asCapturedTypeUnwrappingDnn);
    }

    @Override
    public boolean isCapturedType(@NotNull KotlinTypeMarker $this$isCapturedType) {
        Intrinsics.checkNotNullParameter($this$isCapturedType, "<this>");
        return this.context.isCapturedType($this$isCapturedType);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public DefinitelyNotNullTypeMarker asDefinitelyNotNullType(@NotNull DefinitelyNotNullTypeMarker $this$asDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$asDefinitelyNotNullType, "<this>");
        return this.context.asDefinitelyNotNullType($this$asDefinitelyNotNullType);
    }

    @Override
    @Nullable
    public DefinitelyNotNullTypeMarker asDefinitelyNotNullType(@NotNull RigidTypeMarker $this$asDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$asDefinitelyNotNullType, "<this>");
        return this.context.asDefinitelyNotNullType($this$asDefinitelyNotNullType);
    }

    @Override
    @NotNull
    public SimpleTypeMarker original(@NotNull DefinitelyNotNullTypeMarker $this$original) {
        Intrinsics.checkNotNullParameter($this$original, "<this>");
        return this.context.original($this$original);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public SimpleTypeMarker originalIfDefinitelyNotNullable(@NotNull SimpleTypeMarker $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter($this$originalIfDefinitelyNotNullable, "<this>");
        return this.context.originalIfDefinitelyNotNullable($this$originalIfDefinitelyNotNullable);
    }

    @Override
    @NotNull
    public SimpleTypeMarker originalIfDefinitelyNotNullable(@NotNull RigidTypeMarker $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter($this$originalIfDefinitelyNotNullable, "<this>");
        return this.context.originalIfDefinitelyNotNullable($this$originalIfDefinitelyNotNullable);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public DefinitelyNotNullTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull DefinitelyNotNullTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.context.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull);
    }

    @Override
    @NotNull
    public KotlinTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.context.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull);
    }

    @Override
    @NotNull
    public KotlinTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull, boolean preserveAttributes) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.context.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull, preserveAttributes);
    }

    @Override
    @NotNull
    public RigidTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull RigidTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.context.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull);
    }

    @Override
    public boolean isMarkedNullable(@NotNull KotlinTypeMarker $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "<this>");
        return this.context.isMarkedNullable($this$isMarkedNullable);
    }

    @Override
    @NotNull
    public RigidTypeMarker withNullability(@NotNull RigidTypeMarker $this$withNullability, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$withNullability, "<this>");
        return this.context.withNullability($this$withNullability, nullable);
    }

    @Override
    @NotNull
    public KotlinTypeMarker withNullability(@NotNull KotlinTypeMarker $this$withNullability, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$withNullability, "<this>");
        return this.context.withNullability($this$withNullability, nullable);
    }

    @Override
    @NotNull
    public TypeConstructorMarker typeConstructor(@NotNull RigidTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter($this$typeConstructor, "<this>");
        return this.context.typeConstructor($this$typeConstructor);
    }

    @Override
    @NotNull
    public CapturedTypeConstructorMarker typeConstructor(@NotNull CapturedTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter($this$typeConstructor, "<this>");
        return this.context.typeConstructor($this$typeConstructor);
    }

    @Override
    @NotNull
    public TypeConstructorMarker typeConstructor(@NotNull KotlinTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter($this$typeConstructor, "<this>");
        return this.context.typeConstructor($this$typeConstructor);
    }

    @Override
    public boolean isOldCapturedType(@NotNull CapturedTypeMarker $this$isOldCapturedType) {
        Intrinsics.checkNotNullParameter($this$isOldCapturedType, "<this>");
        return this.context.isOldCapturedType($this$isOldCapturedType);
    }

    @Override
    @NotNull
    public CaptureStatus captureStatus(@NotNull CapturedTypeMarker $this$captureStatus) {
        Intrinsics.checkNotNullParameter($this$captureStatus, "<this>");
        return this.context.captureStatus($this$captureStatus);
    }

    @Override
    public boolean isProjectionNotNull(@NotNull CapturedTypeMarker $this$isProjectionNotNull) {
        Intrinsics.checkNotNullParameter($this$isProjectionNotNull, "<this>");
        return this.context.isProjectionNotNull($this$isProjectionNotNull);
    }

    @Override
    @NotNull
    public TypeArgumentMarker projection(@NotNull CapturedTypeConstructorMarker $this$projection) {
        Intrinsics.checkNotNullParameter($this$projection, "<this>");
        return this.context.projection($this$projection);
    }

    @Override
    public int argumentsCount(@NotNull KotlinTypeMarker $this$argumentsCount) {
        Intrinsics.checkNotNullParameter($this$argumentsCount, "<this>");
        return this.context.argumentsCount($this$argumentsCount);
    }

    @Override
    @NotNull
    public TypeArgumentMarker getArgument(@NotNull KotlinTypeMarker $this$getArgument, int index2) {
        Intrinsics.checkNotNullParameter($this$getArgument, "<this>");
        return this.context.getArgument($this$getArgument, index2);
    }

    @Override
    @NotNull
    public List<TypeArgumentMarker> getArguments(@NotNull KotlinTypeMarker $this$getArguments) {
        Intrinsics.checkNotNullParameter($this$getArguments, "<this>");
        return this.context.getArguments($this$getArguments);
    }

    @Override
    @Nullable
    public TypeArgumentMarker getArgumentOrNull(@NotNull RigidTypeMarker $this$getArgumentOrNull, int index2) {
        Intrinsics.checkNotNullParameter($this$getArgumentOrNull, "<this>");
        return this.context.getArgumentOrNull($this$getArgumentOrNull, index2);
    }

    @Override
    public boolean isStubType(@NotNull RigidTypeMarker $this$isStubType) {
        Intrinsics.checkNotNullParameter($this$isStubType, "<this>");
        return this.context.isStubType($this$isStubType);
    }

    @Override
    public boolean isStubTypeForVariableInSubtyping(@NotNull RigidTypeMarker $this$isStubTypeForVariableInSubtyping) {
        Intrinsics.checkNotNullParameter($this$isStubTypeForVariableInSubtyping, "<this>");
        return this.context.isStubTypeForVariableInSubtyping($this$isStubTypeForVariableInSubtyping);
    }

    @Override
    public boolean isStubTypeForBuilderInference(@NotNull RigidTypeMarker $this$isStubTypeForBuilderInference) {
        Intrinsics.checkNotNullParameter($this$isStubTypeForBuilderInference, "<this>");
        return this.context.isStubTypeForBuilderInference($this$isStubTypeForBuilderInference);
    }

    @Override
    @NotNull
    public TypeConstructorMarker unwrapStubTypeVariableConstructor(@NotNull TypeConstructorMarker $this$unwrapStubTypeVariableConstructor) {
        Intrinsics.checkNotNullParameter($this$unwrapStubTypeVariableConstructor, "<this>");
        return this.context.unwrapStubTypeVariableConstructor($this$unwrapStubTypeVariableConstructor);
    }

    @Override
    @NotNull
    public TypeArgumentMarker asTypeArgument(@NotNull KotlinTypeMarker $this$asTypeArgument) {
        Intrinsics.checkNotNullParameter($this$asTypeArgument, "<this>");
        return this.context.asTypeArgument($this$asTypeArgument);
    }

    @Override
    @Nullable
    public KotlinTypeMarker lowerType(@NotNull CapturedTypeMarker $this$lowerType) {
        Intrinsics.checkNotNullParameter($this$lowerType, "<this>");
        return this.context.lowerType($this$lowerType);
    }

    @Override
    public boolean isStarProjection(@NotNull TypeArgumentMarker $this$isStarProjection) {
        Intrinsics.checkNotNullParameter($this$isStarProjection, "<this>");
        return this.context.isStarProjection($this$isStarProjection);
    }

    @Override
    @NotNull
    public TypeVariance getVariance(@NotNull TypeArgumentMarker $this$getVariance) {
        Intrinsics.checkNotNullParameter($this$getVariance, "<this>");
        return this.context.getVariance($this$getVariance);
    }

    @Override
    @NotNull
    public TypeVariance getVariance(@NotNull TypeParameterMarker $this$getVariance) {
        Intrinsics.checkNotNullParameter($this$getVariance, "<this>");
        return this.context.getVariance($this$getVariance);
    }

    @Override
    @Nullable
    public KotlinTypeMarker getType(@NotNull TypeArgumentMarker $this$getType) {
        Intrinsics.checkNotNullParameter($this$getType, "<this>");
        return this.context.getType($this$getType);
    }

    @Override
    @NotNull
    public TypeArgumentMarker replaceType(@NotNull TypeArgumentMarker $this$replaceType, @NotNull KotlinTypeMarker newType) {
        Intrinsics.checkNotNullParameter($this$replaceType, "<this>");
        Intrinsics.checkNotNullParameter(newType, "newType");
        return this.context.replaceType($this$replaceType, newType);
    }

    @Override
    public int parametersCount(@NotNull TypeConstructorMarker $this$parametersCount) {
        Intrinsics.checkNotNullParameter($this$parametersCount, "<this>");
        return this.context.parametersCount($this$parametersCount);
    }

    @Override
    @NotNull
    public TypeParameterMarker getParameter(@NotNull TypeConstructorMarker $this$getParameter, int index2) {
        Intrinsics.checkNotNullParameter($this$getParameter, "<this>");
        return this.context.getParameter($this$getParameter, index2);
    }

    @Override
    @NotNull
    public List<TypeParameterMarker> getParameters(@NotNull TypeConstructorMarker $this$getParameters) {
        Intrinsics.checkNotNullParameter($this$getParameters, "<this>");
        return this.context.getParameters($this$getParameters);
    }

    @Override
    @NotNull
    public Collection<KotlinTypeMarker> supertypes(@NotNull TypeConstructorMarker $this$supertypes) {
        Intrinsics.checkNotNullParameter($this$supertypes, "<this>");
        return this.context.supertypes($this$supertypes);
    }

    @Override
    public boolean isIntersection(@NotNull TypeConstructorMarker $this$isIntersection) {
        Intrinsics.checkNotNullParameter($this$isIntersection, "<this>");
        return this.context.isIntersection($this$isIntersection);
    }

    @Override
    public boolean isClassTypeConstructor(@NotNull TypeConstructorMarker $this$isClassTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$isClassTypeConstructor, "<this>");
        return this.context.isClassTypeConstructor($this$isClassTypeConstructor);
    }

    @Override
    public boolean isInterface(@NotNull TypeConstructorMarker $this$isInterface) {
        Intrinsics.checkNotNullParameter($this$isInterface, "<this>");
        return this.context.isInterface($this$isInterface);
    }

    @Override
    public boolean isIntegerLiteralTypeConstructor(@NotNull TypeConstructorMarker $this$isIntegerLiteralTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$isIntegerLiteralTypeConstructor, "<this>");
        return this.context.isIntegerLiteralTypeConstructor($this$isIntegerLiteralTypeConstructor);
    }

    @Override
    public boolean isIntegerLiteralConstantTypeConstructor(@NotNull TypeConstructorMarker $this$isIntegerLiteralConstantTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$isIntegerLiteralConstantTypeConstructor, "<this>");
        return this.context.isIntegerLiteralConstantTypeConstructor($this$isIntegerLiteralConstantTypeConstructor);
    }

    @Override
    public boolean isIntegerConstantOperatorTypeConstructor(@NotNull TypeConstructorMarker $this$isIntegerConstantOperatorTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$isIntegerConstantOperatorTypeConstructor, "<this>");
        return this.context.isIntegerConstantOperatorTypeConstructor($this$isIntegerConstantOperatorTypeConstructor);
    }

    @Override
    public boolean isLocalType(@NotNull TypeConstructorMarker $this$isLocalType) {
        Intrinsics.checkNotNullParameter($this$isLocalType, "<this>");
        return this.context.isLocalType($this$isLocalType);
    }

    @Override
    public boolean isAnonymous(@NotNull TypeConstructorMarker $this$isAnonymous) {
        Intrinsics.checkNotNullParameter($this$isAnonymous, "<this>");
        return this.context.isAnonymous($this$isAnonymous);
    }

    @Override
    @Nullable
    public TypeParameterMarker getTypeParameterClassifier(@NotNull TypeConstructorMarker $this$getTypeParameterClassifier) {
        Intrinsics.checkNotNullParameter($this$getTypeParameterClassifier, "<this>");
        return this.context.getTypeParameterClassifier($this$getTypeParameterClassifier);
    }

    @Override
    public boolean isTypeParameterTypeConstructor(@NotNull TypeConstructorMarker $this$isTypeParameterTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$isTypeParameterTypeConstructor, "<this>");
        return this.context.isTypeParameterTypeConstructor($this$isTypeParameterTypeConstructor);
    }

    @Override
    public int upperBoundCount(@NotNull TypeParameterMarker $this$upperBoundCount) {
        Intrinsics.checkNotNullParameter($this$upperBoundCount, "<this>");
        return this.context.upperBoundCount($this$upperBoundCount);
    }

    @Override
    @NotNull
    public KotlinTypeMarker getUpperBound(@NotNull TypeParameterMarker $this$getUpperBound, int index2) {
        Intrinsics.checkNotNullParameter($this$getUpperBound, "<this>");
        return this.context.getUpperBound($this$getUpperBound, index2);
    }

    @Override
    @NotNull
    public List<KotlinTypeMarker> getUpperBounds(@NotNull TypeParameterMarker $this$getUpperBounds) {
        Intrinsics.checkNotNullParameter($this$getUpperBounds, "<this>");
        return this.context.getUpperBounds($this$getUpperBounds);
    }

    @Override
    @NotNull
    public TypeConstructorMarker getTypeConstructor(@NotNull TypeParameterMarker $this$getTypeConstructor) {
        Intrinsics.checkNotNullParameter($this$getTypeConstructor, "<this>");
        return this.context.getTypeConstructor($this$getTypeConstructor);
    }

    @Override
    public boolean hasRecursiveBounds(@NotNull TypeParameterMarker $this$hasRecursiveBounds, @Nullable TypeConstructorMarker selfConstructor) {
        Intrinsics.checkNotNullParameter($this$hasRecursiveBounds, "<this>");
        return this.context.hasRecursiveBounds($this$hasRecursiveBounds, selfConstructor);
    }

    @Override
    public boolean areEqualTypeConstructors(@NotNull TypeConstructorMarker c1, @NotNull TypeConstructorMarker c2) {
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(c2, "c2");
        return this.context.areEqualTypeConstructors(c1, c2);
    }

    @Override
    public boolean isDenotable(@NotNull TypeConstructorMarker $this$isDenotable) {
        Intrinsics.checkNotNullParameter($this$isDenotable, "<this>");
        return this.context.isDenotable($this$isDenotable);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public RigidTypeMarker lowerBoundIfFlexible(@NotNull RigidTypeMarker $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$lowerBoundIfFlexible, "<this>");
        return this.context.lowerBoundIfFlexible($this$lowerBoundIfFlexible);
    }

    @Override
    @NotNull
    public RigidTypeMarker lowerBoundIfFlexible(@NotNull KotlinTypeMarker $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$lowerBoundIfFlexible, "<this>");
        return this.context.lowerBoundIfFlexible($this$lowerBoundIfFlexible);
    }

    @Override
    @Deprecated(message="This call does effectively nothing, please drop it", level=DeprecationLevel.ERROR)
    @NotNull
    public RigidTypeMarker upperBoundIfFlexible(@NotNull RigidTypeMarker $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$upperBoundIfFlexible, "<this>");
        return this.context.upperBoundIfFlexible($this$upperBoundIfFlexible);
    }

    @Override
    @NotNull
    public RigidTypeMarker upperBoundIfFlexible(@NotNull KotlinTypeMarker $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$upperBoundIfFlexible, "<this>");
        return this.context.upperBoundIfFlexible($this$upperBoundIfFlexible);
    }

    @Override
    public boolean isFlexibleWithDifferentTypeConstructors(@NotNull KotlinTypeMarker $this$isFlexibleWithDifferentTypeConstructors) {
        Intrinsics.checkNotNullParameter($this$isFlexibleWithDifferentTypeConstructors, "<this>");
        return this.context.isFlexibleWithDifferentTypeConstructors($this$isFlexibleWithDifferentTypeConstructors);
    }

    @Override
    public boolean isFlexible(@NotNull KotlinTypeMarker $this$isFlexible) {
        Intrinsics.checkNotNullParameter($this$isFlexible, "<this>");
        return this.context.isFlexible($this$isFlexible);
    }

    @Override
    public boolean isDynamic(@NotNull KotlinTypeMarker $this$isDynamic) {
        Intrinsics.checkNotNullParameter($this$isDynamic, "<this>");
        return this.context.isDynamic($this$isDynamic);
    }

    @Override
    public boolean isCapturedDynamic(@NotNull KotlinTypeMarker $this$isCapturedDynamic) {
        Intrinsics.checkNotNullParameter($this$isCapturedDynamic, "<this>");
        return this.context.isCapturedDynamic($this$isCapturedDynamic);
    }

    @Override
    public boolean isDefinitelyNotNullType(@NotNull KotlinTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        return this.context.isDefinitelyNotNullType($this$isDefinitelyNotNullType);
    }

    @Override
    public boolean isDefinitelyNotNullType(@NotNull RigidTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        return this.context.isDefinitelyNotNullType($this$isDefinitelyNotNullType);
    }

    @Override
    public boolean isNotNullTypeParameter(@NotNull KotlinTypeMarker $this$isNotNullTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isNotNullTypeParameter, "<this>");
        return this.context.isNotNullTypeParameter($this$isNotNullTypeParameter);
    }

    @Override
    public boolean hasFlexibleNullability(@NotNull KotlinTypeMarker $this$hasFlexibleNullability) {
        Intrinsics.checkNotNullParameter($this$hasFlexibleNullability, "<this>");
        return this.context.hasFlexibleNullability($this$hasFlexibleNullability);
    }

    @Override
    public boolean isNullableType(@NotNull KotlinTypeMarker $this$isNullableType) {
        Intrinsics.checkNotNullParameter($this$isNullableType, "<this>");
        return this.context.isNullableType($this$isNullableType);
    }

    @Override
    public boolean isNullableAny(@NotNull KotlinTypeMarker $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "<this>");
        return this.context.isNullableAny($this$isNullableAny);
    }

    @Override
    public boolean isNothing(@NotNull KotlinTypeMarker $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return this.context.isNothing($this$isNothing);
    }

    @Override
    public boolean isFlexibleNothing(@NotNull KotlinTypeMarker $this$isFlexibleNothing) {
        Intrinsics.checkNotNullParameter($this$isFlexibleNothing, "<this>");
        return this.context.isFlexibleNothing($this$isFlexibleNothing);
    }

    @Override
    public boolean isNullableNothing(@NotNull KotlinTypeMarker $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "<this>");
        return this.context.isNullableNothing($this$isNullableNothing);
    }

    @Override
    public boolean isClassType(@NotNull RigidTypeMarker $this$isClassType) {
        Intrinsics.checkNotNullParameter($this$isClassType, "<this>");
        return this.context.isClassType($this$isClassType);
    }

    @Override
    @Nullable
    public List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull RigidTypeMarker $this$fastCorrespondingSupertypes, @NotNull TypeConstructorMarker constructor) {
        Intrinsics.checkNotNullParameter($this$fastCorrespondingSupertypes, "<this>");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        return this.context.fastCorrespondingSupertypes($this$fastCorrespondingSupertypes, constructor);
    }

    @Override
    public boolean isIntegerLiteralType(@NotNull RigidTypeMarker $this$isIntegerLiteralType) {
        Intrinsics.checkNotNullParameter($this$isIntegerLiteralType, "<this>");
        return this.context.isIntegerLiteralType($this$isIntegerLiteralType);
    }

    @Override
    @NotNull
    public Collection<KotlinTypeMarker> possibleIntegerTypes(@NotNull RigidTypeMarker $this$possibleIntegerTypes) {
        Intrinsics.checkNotNullParameter($this$possibleIntegerTypes, "<this>");
        return this.context.possibleIntegerTypes($this$possibleIntegerTypes);
    }

    @Override
    public boolean isCommonFinalClassConstructor(@NotNull TypeConstructorMarker $this$isCommonFinalClassConstructor) {
        Intrinsics.checkNotNullParameter($this$isCommonFinalClassConstructor, "<this>");
        return this.context.isCommonFinalClassConstructor($this$isCommonFinalClassConstructor);
    }

    @Override
    @Nullable
    public RigidTypeMarker captureFromArguments(@NotNull RigidTypeMarker type2, @NotNull CaptureStatus status2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)status2, "status");
        return this.context.captureFromArguments(type2, status2);
    }

    @Override
    @Nullable
    public KotlinTypeMarker captureFromExpression(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.context.captureFromExpression(type2);
    }

    @Override
    @NotNull
    public TypeArgumentListMarker asArgumentList(@NotNull RigidTypeMarker $this$asArgumentList) {
        Intrinsics.checkNotNullParameter($this$asArgumentList, "<this>");
        return this.context.asArgumentList($this$asArgumentList);
    }

    @Override
    @NotNull
    public TypeArgumentMarker get(@NotNull TypeArgumentListMarker $this$get, int index2) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        return this.context.get($this$get, index2);
    }

    @Override
    public int size(@NotNull TypeArgumentListMarker $this$size) {
        Intrinsics.checkNotNullParameter($this$size, "<this>");
        return this.context.size($this$size);
    }

    @Override
    @NotNull
    public Iterator<TypeArgumentMarker> iterator(@NotNull TypeArgumentListMarker $this$iterator) {
        Intrinsics.checkNotNullParameter($this$iterator, "<this>");
        return this.context.iterator($this$iterator);
    }

    @Override
    public boolean isAnyConstructor(@NotNull TypeConstructorMarker $this$isAnyConstructor) {
        Intrinsics.checkNotNullParameter($this$isAnyConstructor, "<this>");
        return this.context.isAnyConstructor($this$isAnyConstructor);
    }

    @Override
    public boolean isNothingConstructor(@NotNull TypeConstructorMarker $this$isNothingConstructor) {
        Intrinsics.checkNotNullParameter($this$isNothingConstructor, "<this>");
        return this.context.isNothingConstructor($this$isNothingConstructor);
    }

    @Override
    public boolean isArrayConstructor(@NotNull TypeConstructorMarker $this$isArrayConstructor) {
        Intrinsics.checkNotNullParameter($this$isArrayConstructor, "<this>");
        return this.context.isArrayConstructor($this$isArrayConstructor);
    }

    @Override
    public boolean isSingleClassifierType(@NotNull RigidTypeMarker $this$isSingleClassifierType) {
        Intrinsics.checkNotNullParameter($this$isSingleClassifierType, "<this>");
        return this.context.isSingleClassifierType($this$isSingleClassifierType);
    }

    @Override
    @NotNull
    public KotlinTypeMarker intersectTypes(@NotNull Collection<? extends KotlinTypeMarker> types2) {
        Intrinsics.checkNotNullParameter(types2, "types");
        return this.context.intersectTypes((Collection)types2);
    }

    @Override
    @NotNull
    public SimpleTypeMarker intersectTypes(@NotNull Collection<? extends SimpleTypeMarker> types2) {
        Intrinsics.checkNotNullParameter(types2, "types");
        return this.context.intersectTypes((Collection)types2);
    }

    @Override
    public boolean isRigidType(@NotNull KotlinTypeMarker $this$isRigidType) {
        Intrinsics.checkNotNullParameter($this$isRigidType, "<this>");
        return this.context.isRigidType($this$isRigidType);
    }

    @Override
    public boolean isPrimitiveType(@NotNull RigidTypeMarker $this$isPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveType, "<this>");
        return this.context.isPrimitiveType($this$isPrimitiveType);
    }

    @Override
    public boolean isPrimitiveType(@NotNull SimpleTypeMarker $this$isPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveType, "<this>");
        return this.context.isPrimitiveType($this$isPrimitiveType);
    }

    @Override
    @NotNull
    public List<AnnotationMarker> getAttributes(@NotNull KotlinTypeMarker $this$getAttributes) {
        Intrinsics.checkNotNullParameter($this$getAttributes, "<this>");
        return this.context.getAttributes($this$getAttributes);
    }

    @Override
    @NotNull
    public TypeCheckerState.SupertypesPolicy substitutionSupertypePolicy(@NotNull RigidTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.context.substitutionSupertypePolicy(type2);
    }

    @Override
    public boolean isTypeVariableType(@NotNull KotlinTypeMarker $this$isTypeVariableType) {
        Intrinsics.checkNotNullParameter($this$isTypeVariableType, "<this>");
        return this.context.isTypeVariableType($this$isTypeVariableType);
    }

    @Override
    @NotNull
    public TypeSubstitutorMarker typeSubstitutorByTypeConstructor(@NotNull Map<TypeConstructorMarker, ? extends KotlinTypeMarker> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        return this.context.typeSubstitutorByTypeConstructor(map2);
    }

    @Override
    @NotNull
    public TypeSubstitutorMarker createEmptySubstitutor() {
        return this.context.createEmptySubstitutor();
    }

    @Override
    @NotNull
    public KotlinTypeMarker safeSubstitute(@NotNull TypeSubstitutorMarker $this$safeSubstitute, @NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$safeSubstitute, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.context.safeSubstitute($this$safeSubstitute, type2);
    }

    @Override
    @Nullable
    public TypeParameterMarker getTypeParameter(@NotNull TypeVariableTypeConstructorMarker $this$typeParameter) {
        Intrinsics.checkNotNullParameter($this$typeParameter, "<this>");
        return this.context.getTypeParameter($this$typeParameter);
    }

    @Override
    public boolean identicalArguments(@NotNull RigidTypeMarker a2, @NotNull RigidTypeMarker b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return this.context.identicalArguments(a2, b2);
    }
}

