/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsModuleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.wasm"})
public final class FirWasmJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirWasmJsModuleChecker INSTANCE = new FirWasmJsModuleChecker();

    private FirWasmJsModuleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirFile || !FirAnnotationUtilsKt.hasAnnotation(declaration, WebCommonStandardClassIds.Annotations.JsModule, context.getSession())) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirWasmErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), null, 8, null);
        }
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(declaration.getSymbol(), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirWasmErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_EXTERNAL(), null, 8, null);
        }
        if (FirHelpersKt.isTopLevel(context)) {
            FirFile firFile = context.getContainingFile();
            boolean bl = firFile != null ? FirAnnotationUtilsKt.hasAnnotation(firFile, WebCommonStandardClassIds.Annotations.JsModule, context.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirWasmErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), null, 8, null);
            }
        }
    }
}

