/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmWebCheckerUtils;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;", "<init>", "()V", "isNativeOrExternalInterface", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
public final class FirWasmWebCheckerUtils
extends FirAbstractWebCheckerUtils {
    @NotNull
    public static final FirWasmWebCheckerUtils INSTANCE = new FirWasmWebCheckerUtils();

    private FirWasmWebCheckerUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNativeOrExternalInterface(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(symbol, session)) return false;
        if (!(symbol instanceof FirClassSymbol)) return false;
        FirClassSymbol firClassSymbol = (FirClassSymbol)symbol;
        if (firClassSymbol == null) return false;
        FirClassSymbol $this$isInterface$iv = firClassSymbol;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }
}

