/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "checkType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "CONCURRENT_PACKAGE", "Lorg/jetbrains/kotlin/name/FqName;", "CONCURRENT_NAME_SET", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "checkers.native"})
public final class FirNativeSpecificAtomicChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeSpecificAtomicChecker INSTANCE;
    @NotNull
    private static final FqName CONCURRENT_PACKAGE;
    @NotNull
    private static final Set<Name> CONCURRENT_NAME_SET;

    private FirNativeSpecificAtomicChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility = false;
        if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI() || declaration instanceof FirValueParameter || declaration instanceof FirAnonymousFunction) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = declaration.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            INSTANCE.checkType((FirTypeRef)it, context, reporter);
        }
        Iterable $this$forEach$iv = declaration.getContextParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl = false;
            INSTANCE.checkType(it.getReturnTypeRef(), context, reporter);
        }
        FirTypeRef it = $i$f$forEach = declaration.getReturnTypeRef();
        boolean bl = false;
        KtSourceElement ktSourceElement = it.getSource();
        FirTypeRef firTypeRef = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind ? $i$f$forEach : null;
        if (firTypeRef != null) {
            it = firTypeRef;
            boolean bl2 = false;
            INSTANCE.checkType(it, context, reporter);
        }
        if (!(declaration instanceof FirFunction) || declaration instanceof FirPropertyAccessor) {
            return;
        }
        $this$forEach$iv = ((FirFunction)declaration).getValueParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it2 = (FirValueParameter)element$iv;
            boolean bl3 = false;
            INSTANCE.checkType(it2.getReturnTypeRef(), context, reporter);
        }
    }

    private final void checkType(FirTypeRef typeRef, CheckerContext context, DiagnosticReporter reporter) {
        ClassId classId = FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(typeRef), context.getSession());
        if (classId == null) {
            return;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), CONCURRENT_PACKAGE)) {
            return;
        }
        if (classId2.getParentClassId() != null) {
            return;
        }
        Name name = classId2.getShortClassName();
        if (!CONCURRENT_NAME_SET.contains(name)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirNativeErrors.INSTANCE.getNATIVE_SPECIFIC_ATOMIC(), (Object)name, (DiagnosticContext)context, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new FirNativeSpecificAtomicChecker();
        CONCURRENT_PACKAGE = new FqName("kotlin.concurrent");
        Object object = new String[]{"AtomicIntArray", "AtomicLongArray", "AtomicArray", "AtomicInt", "AtomicLong", "AtomicReference"};
        object = CollectionsKt.listOf(object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier((String)it));
        }
        CONCURRENT_NAME_SET = CollectionsKt.toSet((Iterable)var1_1);
    }
}

