/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "validFirstChars", "", "", "validChars", "checkObjCName", "objCName", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities$ObjCName;", "checkers.native"})
public final class FirNativeObjCNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeObjCNameChecker INSTANCE = new FirNativeObjCNameChecker();
    @NotNull
    private static final Set<Character> validFirstChars = SetsKt.plus(SetsKt.plus(CollectionsKt.toSet(new CharRange('A', 'Z')), CollectionsKt.toSet(new CharRange('a', 'z'))), Character.valueOf('_'));
    @NotNull
    private static final Set<Character> validChars = SetsKt.plus(validFirstChars, CollectionsKt.toSet(new CharRange('0', '9')));

    private FirNativeObjCNameChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirValueParameter) {
            return;
        }
        List<FirNativeObjCNameUtilities.ObjCName> objCNames = CollectionsKt.filterNotNull((Iterable)FirNativeObjCNameUtilities.INSTANCE.getObjCNames(declaration.getSymbol(), context.getSession()));
        if (objCNames.isEmpty()) {
            return;
        }
        if (declaration instanceof FirCallableDeclaration) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                for (FirNativeObjCNameUtilities.ObjCName objCName : objCNames) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)objCName.getAnnotation().getSource(), FirNativeErrors.INSTANCE.getINAPPLICABLE_OBJC_NAME(), null, 8, null);
                }
            }
        }
        Iterable $this$forEach$iv = objCNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirNativeObjCNameUtilities.ObjCName it = (FirNativeObjCNameUtilities.ObjCName)element$iv;
            boolean bl = false;
            INSTANCE.checkObjCName(it, declaration, context, reporter);
        }
    }

    private final void checkObjCName(FirNativeObjCNameUtilities.ObjCName objCName, FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        Set<Character> invalidSwiftNameChars;
        Set<Character> invalidChars;
        Set<Character> set;
        Set<Character> invalidNameChars;
        Set<Character> set2;
        Set<Character> invalidFirstChars;
        KtSourceElement annotationSource;
        block16: {
            block15: {
                Object object;
                Object object2;
                Character[] invalidNameFirstChar;
                Object object3;
                Object object4;
                Character[] characterArray;
                Character[] characterArray2;
                annotationSource = objCName.getAnnotation().getSource();
                Iterator<Map.Entry<Name, FirExpression>> iterator2 = objCName.getAnnotation().getArgumentMapping().getMapping().entrySet().iterator();
                while (iterator2.hasNext()) {
                    FirExpression argument = iterator2.next().getValue();
                    if (argument instanceof FirLiteralExpression) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirNativeErrors.INSTANCE.getNON_LITERAL_OBJC_NAME_ARG(), (DiagnosticContext)context, null, 8, null);
                }
                if (objCName.getName() == null && objCName.getSwiftName() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME(), (DiagnosticContext)context, null, 8, null);
                }
                if ((characterArray2 = objCName.getName()) != null && (characterArray2 = StringsKt.firstOrNull((CharSequence)characterArray2)) != null) {
                    characterArray = characterArray2;
                    object4 = validFirstChars;
                    char p0 = characterArray.charValue();
                    boolean bl = false;
                    object3 = !object4.contains(Character.valueOf(p0)) ? characterArray : null;
                } else {
                    object3 = invalidNameFirstChar = null;
                }
                if ((object2 = objCName.getSwiftName()) != null && (object2 = StringsKt.firstOrNull((CharSequence)object2)) != null) {
                    object4 = object2;
                    Set<Character> p0 = validFirstChars;
                    char p02 = ((Character)object4).charValue();
                    boolean bl = false;
                    object = !p0.contains(Character.valueOf(p02)) ? object4 : null;
                } else {
                    object = null;
                }
                Object invalidSwiftNameFirstChar = object;
                characterArray = new Character[]{invalidNameFirstChar, invalidSwiftNameFirstChar};
                invalidFirstChars = SetsKt.setOfNotNull(characterArray);
                if (!((Collection)invalidFirstChars).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_FIRST_CHAR(), (Object)CollectionsKt.joinToString$default(invalidFirstChars, "", null, null, 0, null, null, 62, null), (DiagnosticContext)context, null, 16, null);
                }
                String string = objCName.getName();
                if (string != null ? ((CharSequence)string).length() == 0 : false) break block15;
                String string2 = objCName.getSwiftName();
                boolean bl = string2 != null ? ((CharSequence)string2).length() == 0 : false;
                if (!bl) break block16;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getEMPTY_OBJC_NAME(), (DiagnosticContext)context, null, 8, null);
        }
        if ((set2 = objCName.getName()) == null || (set2 = StringsKt.toSet((CharSequence)((Object)set2))) == null || (set2 = CollectionsKt.subtract((Iterable)set2, (Iterable)validChars)) == null) {
            set2 = invalidNameChars = SetsKt.emptySet();
        }
        if ((set = objCName.getSwiftName()) == null || (set = StringsKt.toSet((CharSequence)((Object)set))) == null || (set = CollectionsKt.subtract((Iterable)set, (Iterable)validChars)) == null) {
            set = SetsKt.emptySet();
        }
        if (!((Collection)(invalidChars = SetsKt.plus(invalidNameChars, (Iterable)(invalidSwiftNameChars = set)))).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_CHARS(), (Object)CollectionsKt.joinToString$default(invalidFirstChars, "", null, null, 0, null, null, 62, null), (DiagnosticContext)context, null, 16, null);
        }
        if (objCName.getExact() && (!(declaration instanceof FirClass) || ((FirClass)declaration).getClassKind() == ClassKind.ENUM_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINAPPLICABLE_EXACT_OBJC_NAME(), (DiagnosticContext)context, null, 8, null);
        }
        if (objCName.getExact() && objCName.getName() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getMISSING_EXACT_OBJC_NAME(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

