/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"jdkInternalValueBasedAnnotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isJavaValueBasedClass", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isJavaValueBasedClassAndWarningsEnabled", "isValueTypeAndWarningsEnabled", "checkers.jvm"})
public final class FirJavaValueBasedClassUtilsKt {
    @NotNull
    private static final ClassId jdkInternalValueBasedAnnotationClassId = ClassId.Companion.fromString$default(ClassId.Companion, "jdk/internal/ValueBased", false, 2, null);

    public static final boolean isJavaValueBasedClass(@NotNull ConeKotlinType $this$isJavaValueBasedClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isJavaValueBasedClass, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol($this$isJavaValueBasedClass, session);
        if (firClassSymbol == null) {
            return false;
        }
        FirClassSymbol<?> classSymbol = firClassSymbol;
        return FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)classSymbol, jdkInternalValueBasedAnnotationClassId, session);
    }

    public static final boolean isJavaValueBasedClassAndWarningsEnabled(@NotNull ConeKotlinType $this$isJavaValueBasedClassAndWarningsEnabled, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isJavaValueBasedClassAndWarningsEnabled, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return !FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.DisableWarningsForValueBasedJavaClasses) && FirJavaValueBasedClassUtilsKt.isJavaValueBasedClass($this$isJavaValueBasedClassAndWarningsEnabled, session);
    }

    public static final boolean isValueTypeAndWarningsEnabled(@NotNull ConeKotlinType $this$isValueTypeAndWarningsEnabled, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isValueTypeAndWarningsEnabled, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.DisableWarningsForIdentitySensitiveOperationsOnValueClassesAndPrimitives) && (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isValueTypeAndWarningsEnabled) || FirHelpersKt.isValueClass($this$isValueTypeAndWarningsEnabled, session))) {
            return true;
        }
        return FirJavaValueBasedClassUtilsKt.isJavaValueBasedClassAndWarningsEnabled($this$isValueTypeAndWarningsEnabled, session);
    }
}

