/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluator;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J*\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0002H\u0002J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001b\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001c\u001a\u00020\u0015*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExposeBoxedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkJvmExposeBoxedAnnotation", "jvmExposeBoxedAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkJvmNameHasDifferentName", "name", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "cannotRename", "", "isWithInlineClass", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isMangledOrWithResult", "canBeOverloadedByExposed", "isInline", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers.jvm"})
public final class FirJvmExposeBoxedChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmExposeBoxedChecker INSTANCE = new FirJvmExposeBoxedChecker();

    private FirJvmExposeBoxedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirAnnotation jvmExposeBoxedAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.INSTANCE.getJVM_EXPOSE_BOXED_ANNOTATION_CLASS_ID(), context.getSession());
        if (jvmExposeBoxedAnnotation != null) {
            this.checkJvmExposeBoxedAnnotation(jvmExposeBoxedAnnotation, declaration, reporter, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkJvmExposeBoxedAnnotation(FirAnnotation jvmExposeBoxedAnnotation, FirDeclaration declaration, DiagnosticReporter reporter, CheckerContext context) {
        FirExpression name = FirAnnotationUtilsKt.findArgumentByName$default(jvmExposeBoxedAnnotation, JvmStandardClassIds.Annotations.ParameterNames.INSTANCE.getJvmExposeBoxedName(), false, 2, null);
        if (name != null) {
            String value2;
            void $this$evaluateAs$iv;
            if (this.cannotRename(declaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)name.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_EXPOSE_BOXED_WITH_NAME(), (DiagnosticContext)context, null, 8, null);
            }
            FirExpression firExpression = name;
            FirSession session$iv = context.getSession();
            boolean $i$f$evaluateAs = false;
            FirEvaluatorResult firEvaluatorResult = FirExpressionEvaluator.INSTANCE.evaluateExpression((FirExpression)$this$evaluateAs$iv, session$iv);
            FirElement firElement = firEvaluatorResult != null ? FirAnnotationUtilsKt.getResult(firEvaluatorResult) : null;
            if (!(firElement instanceof FirLiteralExpression)) {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)((FirElement)((FirLiteralExpression)firElement));
            Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            String string = value2 = object instanceof String ? (String)object : null;
            if (value2 != null && !Name.isValidIdentifier(value2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)name.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JVM_NAME(), (DiagnosticContext)context, null, 8, null);
            }
        }
        if (declaration instanceof FirClass) {
            FirClass $this$isInterface$iv = (FirClass)declaration;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_OPEN_ABSTRACT(), (DiagnosticContext)context, null, 8, null);
            }
        }
        if (declaration instanceof FirCallableDeclaration) {
            boolean bl;
            block23: {
                Modality modality$iv;
                if (!this.isWithInlineClass((FirCallableDeclaration)declaration, context.getSession())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getUSELESS_JVM_EXPOSE_BOXED(), (DiagnosticContext)context, null, 8, null);
                } else if (name == null && !this.isMangledOrWithResult((FirCallableDeclaration)declaration, context.getSession()) && declaration instanceof FirFunction) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_REQUIRES_NAME(), (DiagnosticContext)context, null, 8, null);
                }
                if (FirAnnotationUtilsKt.hasAnnotation(declaration, JvmStandardClassIds.JVM_SYNTHETIC_ANNOTATION_CLASS_ID, context.getSession())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_SYNTHETIC(), (DiagnosticContext)context, null, 8, null);
                }
                FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isFinal = false;
                Modality modality = $this$isFinal$iv.getStatus().getModality();
                if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
                    boolean bl2;
                    Object object = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)declaration);
                    if (object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, context.getSession())) != null) {
                        FirClassLikeSymbol $this$isFinal$iv2 = (FirClassLikeSymbol)object;
                        boolean $i$f$isFinal2 = false;
                        bl2 = !($this$isFinal$iv2.getResolvedStatus().getModality() == Modality.FINAL);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_OPEN_ABSTRACT(), (DiagnosticContext)context, null, 8, null);
                    }
                }
                if (!this.canBeOverloadedByExposed((FirCallableDeclaration)declaration, context.getSession())) {
                    this.checkJvmNameHasDifferentName(name, declaration, reporter, context);
                }
                Iterable $this$any$iv = ClassMembersKt.getPropertyIfAccessor((FirCallableDeclaration)declaration).getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_REIFIED(), (DiagnosticContext)context, null, 8, null);
            }
            if (declaration instanceof FirFunction) {
                FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_SUSPEND(), (DiagnosticContext)context, null, 8, null);
                }
            }
            if (DeclarationUtilsKt.isLocalMember(declaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmExposeBoxedAnnotation.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_EXPOSE_LOCALS(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkJvmNameHasDifferentName(FirExpression name, FirDeclaration declaration, DiagnosticReporter reporter, CheckerContext context) {
        void $this$evaluateAs$iv;
        if (name == null) {
            return;
        }
        FirExpression firExpression = name;
        FirSession session$iv = context.getSession();
        boolean $i$f$evaluateAs = false;
        FirEvaluatorResult firEvaluatorResult = FirExpressionEvaluator.INSTANCE.evaluateExpression((FirExpression)$this$evaluateAs$iv, session$iv);
        FirElement firElement = firEvaluatorResult != null ? FirAnnotationUtilsKt.getResult(firEvaluatorResult) : null;
        if (!(firElement instanceof FirLiteralExpression)) {
            firElement = null;
        }
        FirLiteralExpression firLiteralExpression = (FirLiteralExpression)((FirElement)((FirLiteralExpression)firElement));
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String value2 = string;
        if (Intrinsics.areEqual(value2, JavaUtilsKt.findJvmNameValue(declaration))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)name.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_BE_THE_SAME_AS_JVM_NAME(), (DiagnosticContext)context, null, 8, null);
        }
        if (declaration instanceof FirFunction && Intrinsics.areEqual(FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration).asString(), value2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)name.getSource(), FirJvmErrors.INSTANCE.getJVM_EXPOSE_BOXED_CANNOT_BE_THE_SAME(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean cannotRename(FirDeclaration $this$cannotRename) {
        return $this$cannotRename instanceof FirClass || $this$cannotRename instanceof FirConstructor;
    }

    private final boolean isWithInlineClass(FirCallableDeclaration $this$isWithInlineClass, FirSession session) {
        if (this.canBeOverloadedByExposed($this$isWithInlineClass, session)) {
            return true;
        }
        return this.isInline($this$isWithInlineClass.getReturnTypeRef(), session);
    }

    private final boolean isMangledOrWithResult(FirCallableDeclaration $this$isMangledOrWithResult, FirSession session) {
        FirRegularClassSymbol containingClass;
        if (this.canBeOverloadedByExposed($this$isMangledOrWithResult, session)) {
            return true;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$isMangledOrWithResult);
        FirRegularClassSymbol firRegularClassSymbol = containingClass = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, session) : null;
        if (containingClass != null) {
            return this.isInline($this$isMangledOrWithResult.getReturnTypeRef(), session);
        }
        return false;
    }

    private final boolean canBeOverloadedByExposed(FirCallableDeclaration $this$canBeOverloadedByExposed, FirSession session) {
        FirValueParameter it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block10: {
            FirPureAbstractElement firPureAbstractElement = $this$canBeOverloadedByExposed.getReceiverParameter();
            boolean bl2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? this.isInline((FirTypeRef)firPureAbstractElement, session) : false;
            if (bl2) {
                return true;
            }
            $this$any$iv = $this$canBeOverloadedByExposed.getContextParameters();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FirValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!INSTANCE.isInline(it.getReturnTypeRef(), session)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if ($this$canBeOverloadedByExposed instanceof FirFunction) {
            boolean bl4;
            block11: {
                $this$any$iv = ((FirFunction)$this$canBeOverloadedByExposed).getValueParameters();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FirValueParameter)element$iv;
                        boolean bl5 = false;
                        if (!INSTANCE.isInline(it.getReturnTypeRef(), session)) continue;
                        bl4 = true;
                        break block11;
                    }
                    bl4 = false;
                }
            }
            if (bl4) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInline(FirTypeRef $this$isInline, FirSession session) {
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isInline, session);
        if (firRegularClassSymbol == null) return false;
        FirClassLikeSymbol $this$isInlineOrValue$iv = firRegularClassSymbol;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv$iv.getRawStatus().isInline()) return true;
        FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isValue = false;
        if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        return true;
    }
}

