/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.java.enhancement.InheritedKtPrivateClassDataKeyKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJavaClassInheritsKtPrivateClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;)V", "checkers.jvm"})
public final class FirJavaClassInheritsKtPrivateClassDeclarationChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirJavaClassInheritsKtPrivateClassDeclarationChecker INSTANCE = new FirJavaClassInheritsKtPrivateClassDeclarationChecker();

    private FirJavaClassInheritsKtPrivateClassDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirConstructor declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitJavaClassInheritingPrivateKotlinClass)) {
            return;
        }
        FirDelegatedConstructorCall firDelegatedConstructorCall = declaration.getDelegatedConstructor();
        if (firDelegatedConstructorCall == null) {
            return;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = firDelegatedConstructorCall;
        FirConstructorSymbol firConstructorSymbol = declaration.getSymbol().getResolvedDelegatedConstructor();
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol resolvedDelegatedConstructor = firConstructorSymbol;
        ConeKotlinType inheritedKtPrivateCls = InheritedKtPrivateClassDataKeyKt.getInheritedKtPrivateCls(resolvedDelegatedConstructor);
        if (inheritedKtPrivateCls != null) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(resolvedDelegatedConstructor);
            Intrinsics.checkNotNull(coneClassLikeLookupTag);
            ClassId javaClassId = coneClassLikeLookupTag.getClassId();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)delegatedConstructorCall.getSource(), FirJvmErrors.INSTANCE.getJAVA_CLASS_INHERITS_KT_PRIVATE_CLASS(), (Object)javaClassId, (Object)inheritedKtPrivateCls, null, 32, null);
        }
    }
}

