/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

public final class FirJsModuleQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsModuleQualifiedAccessChecker INSTANCE = new FirJsModuleQualifiedAccessChecker();

    private FirJsModuleQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkReifiedTypeParameters(expression, context, reporter);
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> calleeSymbols = this.extractModuleCalleeSymbols(expression);
        for (Pair<FirBasedSymbol<?>, AbstractKtSourceElement> pair : calleeSymbols) {
            FirBasedSymbol<?> calleeSymbol = pair.component1();
            AbstractKtSourceElement source = pair.component2();
            AbstractKtSourceElement abstractKtSourceElement = source;
            if (abstractKtSourceElement == null) {
                abstractKtSourceElement = expression.getSource();
            }
            FirJsModuleCheckUtilsKt.checkJsModuleUsage(calleeSymbol, context, reporter, abstractKtSourceElement);
        }
    }

    private final List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> extractModuleCalleeSymbols(FirQualifiedAccessExpression expression) {
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> list;
        FirExpression receiver;
        FirBasedSymbol calleeSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression.getCalleeReference(), false, 1, null);
        if (calleeSymbol != null && FirHelpersKt.getContainingClassSymbol(calleeSymbol) == null) {
            return CollectionsKt.listOf(TuplesKt.to(calleeSymbol, expression.getCalleeReference().getSource()));
        }
        FirExpression firExpression = expression.getDispatchReceiver();
        FirExpression firExpression2 = receiver = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        if (receiver == null) {
            FirBasedSymbol firBasedSymbol = calleeSymbol;
            list = CollectionsKt.listOfNotNull(firBasedSymbol != null ? TuplesKt.to(firBasedSymbol, expression.getCalleeReference().getSource()) : null);
        } else if (receiver instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> classSymbol = ((FirResolvedQualifier)receiver).getSymbol();
            if (expression instanceof FirCallableReferenceAccess) {
                Pair[] pairArray = new Pair[2];
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                pairArray[0] = firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, ((FirResolvedQualifier)receiver).getSource()) : null;
                FirBasedSymbol firBasedSymbol = calleeSymbol;
                pairArray[1] = firBasedSymbol != null ? TuplesKt.to(firBasedSymbol, ((FirCallableReferenceAccess)expression).getCalleeReference().getSource()) : null;
                list = CollectionsKt.listOfNotNull(pairArray);
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                list = CollectionsKt.listOfNotNull(firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, expression.getCalleeReference().getSource()) : null);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifiedTypeParameters(FirQualifiedAccessExpression expr, CheckerContext context, DiagnosticReporter reporter) {
        block3: {
            FirFunctionCall firFunctionCall = expr instanceof FirFunctionCall ? (FirFunctionCall)expr : null;
            if (firFunctionCall == null) break block3;
            FirFunctionCall $this$forAllReifiedTypeParameters$iv = firFunctionCall;
            boolean $i$f$forAllReifiedTypeParameters = false;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$forAllReifiedTypeParameters$iv.getCalleeReference(), false, 1, null);
            if (firNamedFunctionSymbol != null) {
                FirNamedFunctionSymbol functionSymbol$iv = firNamedFunctionSymbol;
                for (Pair pair : CollectionsKt.zip((Iterable)functionSymbol$iv.getTypeParameterSymbols(), (Iterable)$this$forAllReifiedTypeParameters$iv.getTypeArguments())) {
                    FirRegularClassSymbol typeArgumentClass;
                    void typeArgument;
                    ConeKotlinType type$iv;
                    FirTypeParameterSymbol typeParameterSymbol$iv = (FirTypeParameterSymbol)pair.component1();
                    FirTypeProjection typeArgument$iv = (FirTypeProjection)pair.component2();
                    if (!typeParameterSymbol$iv.isReified() || !(typeArgument$iv instanceof FirTypeProjectionWithVariance) || FirTypeUtilsKt.getConeTypeOrNull(((FirTypeProjectionWithVariance)typeArgument$iv).getTypeRef()) == null) continue;
                    FirTypeProjectionWithVariance firTypeProjectionWithVariance = (FirTypeProjectionWithVariance)typeArgument$iv;
                    ConeKotlinType type2 = type$iv;
                    boolean bl = false;
                    if (ToSymbolUtilsKt.toRegularClassSymbol(type2, context.getSession()) == null) continue;
                    KtSourceElement ktSourceElement = typeArgument.getSource();
                    if (ktSourceElement == null && (ktSourceElement = ((FirFunctionCall)expr).getCalleeReference().getSource()) == null) {
                        ktSourceElement = ((FirFunctionCall)expr).getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    FirJsModuleCheckUtilsKt.checkJsModuleUsage(typeArgumentClass, context, reporter, source);
                }
            }
        }
    }
}

