/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

public final class FirJsModuleGetClassCallChecker
extends FirExpressionChecker<FirGetClassCall> {
    @NotNull
    public static final FirJsModuleGetClassCallChecker INSTANCE = new FirJsModuleGetClassCallChecker();

    private FirJsModuleGetClassCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirGetClassCall expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        FirClassifierSymbol<?> firClassifierSymbol = ToSymbolUtilsKt.toSymbol(FirTypeUtilsKt.getResolvedType(expression.getArgument()), context.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> callee = firClassifierSymbol;
        FirJsModuleCheckUtilsKt.checkJsModuleUsage((FirBasedSymbol)callee, context, reporter, expression.getSource());
    }
}

