/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsExternalArgumentCallChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirJsExternalArgumentCallChecker INSTANCE = new FirJsExternalArgumentCallChecker();

    private FirJsExternalArgumentCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirCall expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        FirCall $this$resolvedArgumentMapping$iv = expression;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<FirExpression, FirValueParameter> arguments2 = linkedHashMap;
        for (Map.Entry entry : ((Map)arguments2).entrySet()) {
            FirRegularClassSymbol symbol;
            FirExpression argument = (FirExpression)entry.getKey();
            FirValueParameter parameter = (FirValueParameter)entry.getValue();
            if (!FirAnnotationUtilsKt.hasAnnotation(parameter, JsStandardClassIds.Annotations.JsExternalArgument, context.getSession())) continue;
            FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(argument);
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(unwrappedArg);
            FirRegularClassSymbol firRegularClassSymbol = symbol = ToSymbolUtilsKt.toRegularClassSymbol(type2, context.getSession());
            boolean bl = firRegularClassSymbol != null ? !FirWebCommonHelpersKt.isEffectivelyExternal(firRegularClassSymbol, context.getSession()) : false;
            if (!bl && !(type2 instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)unwrappedArg.getSource(), FirJsErrors.INSTANCE.getJS_EXTERNAL_ARGUMENT(), (Object)type2, null, 16, null);
        }
    }
}

