/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsDefinedExternallyCallChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirJsDefinedExternallyCallChecker INSTANCE = new FirJsDefinedExternallyCallChecker();

    private FirJsDefinedExternallyCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Object object = ReferenceUtilsKt.toReference(expression, context.getSession());
        if (object == null || (object = FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object symbol = object;
        if (!Intrinsics.areEqual(((FirCallableSymbol)symbol).getCallableId(), JsStandardClassIds.Callables.JsDefinedExternally)) {
            return;
        }
        Object object2 = FirHelpersKt.getClosestNonLocal(context);
        if (object2 == null || (object2 = ((FirDeclaration)object2).getSymbol()) == null) {
            return;
        }
        Object container = object2;
        if (!FirJsHelpersKt.isNativeObject(container, context) && !FirJsHelpersKt.isPredefinedObject(container, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)expression.getSource(), FirJsErrors.INSTANCE.getCALL_TO_DEFINED_EXTERNALLY_FROM_NON_EXTERNAL_DECLARATION(), null, 8, null);
        }
    }
}

