/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

public final class FirJsRuntimeAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsRuntimeAnnotationChecker INSTANCE = new FirJsRuntimeAnnotationChecker();

    private FirJsRuntimeAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        for (FirAnnotation annotation : declaration.getAnnotations()) {
            FirClassLikeSymbol<?> annotationClassSymbol;
            if (FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, context.getSession()) == null || FirRetentionAnnotationHelpersKt.getExplicitAnnotationRetention(annotationClassSymbol, context.getSession()) != AnnotationRetention.RUNTIME) continue;
            if (declaration instanceof FirMemberDeclaration && FirJsHelpersKt.isEffectivelyExternal(((FirMemberDeclaration)declaration).getSymbol(), context)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_ON_EXTERNAL_DECLARATION(), null, 8, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_NOT_SUPPORTED(), null, 8, null);
        }
    }
}

