/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

public final class FirJsPropertyDelegationByDynamicChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirJsPropertyDelegationByDynamicChecker INSTANCE = new FirJsPropertyDelegationByDynamicChecker();

    private FirJsPropertyDelegationByDynamicChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirExpression firExpression = declaration.getDelegate();
        if ((firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null) instanceof ConeDynamicType) {
            FirExpression firExpression2 = declaration.getDelegate();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)(firExpression2 != null ? firExpression2.getSource() : null), FirJsErrors.INSTANCE.getPROPERTY_DELEGATION_BY_DYNAMIC(), null, 8, null);
        }
    }
}

