/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

public final class FirJsPackageDirectiveChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirJsPackageDirectiveChecker INSTANCE = new FirJsPackageDirectiveChecker();

    private FirJsPackageDirectiveChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (UtilsKt.getPackageFqName(declaration).isRoot()) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getPackageDirective().getSource();
        if (ktSourceElement != null) {
            void types$iv;
            void $this$forEachChildOfType_u24default$iv;
            KtSourceElement ktSourceElement2 = ktSourceElement;
            Set<IElementType> set = SetsKt.setOf(KtNodeTypes.REFERENCE_EXPRESSION);
            int depth$iv = -1;
            boolean reverse$iv = false;
            boolean $i$f$forEachChildOfType = false;
            void var9_9 = $this$forEachChildOfType_u24default$iv;
            if (var9_9 instanceof KtPsiSourceElement) {
                PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                boolean $i$f$forEachChildOfType2 = false;
                boolean $i$f$forEachChildOfType3 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    PsiElement it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                        void var18_26 = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                        if (var18_26.contains(iElementType)) {
                            String name;
                            KtPsiSourceElement ktPsiSourceElement;
                            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                            boolean bl2 = false;
                            PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                            KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            KtSourceElement it = ktPsiSourceElement;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue(KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), "unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name), name)) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name + " contains illegal characters"), null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (PsiElement)element$iv$iv$iv;
                    boolean bl = false;
                    List list = SequencesKt.toList(PsiUtilsKt.getAllChildren(it$iv$iv));
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf22 = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl4 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                    while ($i$f$butIf22.hasNext()) {
                        Object element$iv$iv$iv$iv;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                        boolean bl5 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else if (var9_9 instanceof KtLightSourceElement) {
                LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
                FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                boolean $i$f$forEachChildOfType4 = false;
                boolean $i$f$forEachChildOfType5 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    LighterASTNode it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                        void var19_29 = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getTokenType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getTokenType(...)");
                        if (var19_29.contains(iElementType)) {
                            String name;
                            void $this$toKtLightSourceElement_u24default$iv$iv;
                            LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                            boolean bl6 = false;
                            LighterASTNode kind$iv$iv = it$iv;
                            FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                            KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                            int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                            int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                            boolean $i$f$toKtLightSourceElement = false;
                            KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                            boolean bl7 = false;
                            Intrinsics.checkNotNullExpressionValue(KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), "unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name), name)) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name + " contains illegal characters"), null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                    boolean bl = false;
                    List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl8 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv$iv2;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                        boolean bl9 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

