/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeIndexerChecker;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsNativeSetterChecker
extends FirJsAbstractNativeIndexerChecker {
    @NotNull
    public static final FirJsNativeSetterChecker INSTANCE = new FirJsNativeSetterChecker();

    private FirJsNativeSetterChecker() {
        super(JsStandardClassIds.Annotations.JsNativeSetter, "setter", 2);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.hasRequiredAnnotation(declaration, context)) {
            return;
        }
        super.check(context, reporter, declaration);
        ConeKotlinType returnType = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
        if (ConeBuiltinTypeUtilsKt.isUnit(returnType)) {
            return;
        }
        if (declaration.getValueParameters().size() < 2) {
            return;
        }
        ConeKotlinType secondParameterType = FirTypeUtilsKt.getConeType(declaration.getValueParameters().get(1).getReturnTypeRef());
        if (TypeUtilsKt.isSubtypeOf$default(secondParameterType, returnType, context.getSession(), false, 4, null)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_SETTER_WRONG_RETURN_TYPE(), null, 8, null);
    }
}

