/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeIndexerChecker;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsNativeGetterChecker
extends FirJsAbstractNativeIndexerChecker {
    @NotNull
    public static final FirJsNativeGetterChecker INSTANCE = new FirJsNativeGetterChecker();

    private FirJsNativeGetterChecker() {
        super(JsStandardClassIds.Annotations.JsNativeGetter, "getter", 1);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.hasRequiredAnnotation(declaration, context)) {
            return;
        }
        super.check(context, reporter, declaration);
        if (!ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_GETTER_RETURN_TYPE_SHOULD_BE_NULLABLE(), null, 8, null);
        }
    }
}

