/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableName;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableNameKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

public final class FirJsNameClashFileTopLevelDeclarationsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirJsNameClashFileTopLevelDeclarationsChecker INSTANCE = new FirJsNameClashFileTopLevelDeclarationsChecker();

    private FirJsNameClashFileTopLevelDeclarationsChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStableName(Map<String, List<FirJsStableName>> $this$addStableName, FirBasedSymbol<?> symbol, CheckerContext context) {
        block5: {
            FirJsStableName stableName = FirJsStableName.Companion.createStableNameOrNull(symbol, context.getSession());
            if (stableName != null) {
                Object object;
                void $this$getOrPut$iv;
                Map<String, List<FirJsStableName>> map2 = $this$addStableName;
                String key$iv = stableName.getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(stableName);
            }
            if (!(symbol instanceof FirPropertySymbol)) break block5;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)symbol).getGetterSymbol();
            if (firPropertyAccessorSymbol != null) {
                FirPropertyAccessorSymbol getter = firPropertyAccessorSymbol;
                boolean bl = false;
                INSTANCE.addStableName($this$addStableName, getter, context);
            }
            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)symbol).getSetterSymbol();
            if (firPropertyAccessorSymbol2 != null) {
                FirPropertyAccessorSymbol setter = firPropertyAccessorSymbol2;
                boolean bl = false;
                INSTANCE.addStableName($this$addStableName, setter, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Map topLevelDeclarationsWithStableName = new LinkedHashMap();
        for (FirDeclaration entry : declaration.getDeclarations()) {
            this.addStableName(topLevelDeclarationsWithStableName, entry.getSymbol(), context);
        }
        for (Map.Entry entry : topLevelDeclarationsWithStableName.entrySet()) {
            String name = (String)entry.getKey();
            List stableNames = (List)entry.getValue();
            for (FirJsStableName symbol : stableNames) {
                Collection<FirBasedSymbol<?>> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<FirJsStableName> clashed;
                Iterable<FirJsStableName> iterable;
                List<FirJsStableName> it = iterable = FirJsStableNameKt.collectNameClashesWith(stableNames, symbol);
                boolean $i$a$-takeIf-FirJsNameClashFileTopLevelDeclarationsChecker$check$clashed$232 = false;
                if ((!((Collection)it).isEmpty() ? iterable : null) == null) continue;
                clashed = clashed;
                KtSourceElement ktSourceElement = symbol.getSymbol().getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = declaration.getSource();
                }
                KtSourceElement source = ktSourceElement;
                iterable = clashed;
                String string = name;
                KtDiagnosticFactory2<String, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirJsErrors.INSTANCE.getJS_NAME_CLASH();
                AbstractKtSourceElement abstractKtSourceElement = source;
                DiagnosticReporter diagnosticReporter = reporter;
                DiagnosticContext diagnosticContext = context;
                boolean $i$f$map = false;
                void $i$a$-takeIf-FirJsNameClashFileTopLevelDeclarationsChecker$check$clashed$232 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FirJsStableName firJsStableName = (FirJsStableName)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getSymbol());
                }
                collection = (List)destination$iv$iv;
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)string, (Object)collection, null, 32, null);
            }
        }
    }
}

