/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableName;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

public final class FirJsNameCharsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsNameCharsChecker INSTANCE = new FirJsNameCharsChecker();

    private FirJsNameCharsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        if ((declaration instanceof FirPropertyAccessor || declaration instanceof FirPrimaryConstructor) && FirJsHelpersKt.getJsName((FirBasedSymbol)((FirFunction)declaration).getSymbol(), context.getSession()) == null) {
            return;
        }
        if (declaration instanceof FirConstructor && FirJsHelpersKt.getJsName(((FirConstructor)declaration).getSymbol(), context.getSession()) == null && FirJsHelpersKt.isExportedObject((FirBasedSymbol)((FirConstructor)declaration).getSymbol(), context.getSession())) {
            return;
        }
        FirJsStableName firJsStableName = FirJsStableName.Companion.createStableNameOrNull(declaration.getSymbol(), context.getSession());
        if (firJsStableName == null) {
            return;
        }
        FirJsStableName stableName = firJsStableName;
        if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(stableName.getName()), stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNAME_CONTAINS_ILLEGAL_CHARS(), null, 8, null);
        }
    }
}

