/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public abstract class FirJsMultipleInheritanceChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsMultipleInheritanceChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.checkFunctionIfSubtypeOf(declaration, OperatorNameConventions.GET, context.getSession().getBuiltinTypes().getCharSequenceType().getConeType(), context, reporter);
        this.checkFunctionIfSubtypeOf(declaration, StandardNames.NEXT_CHAR, context.getSession().getBuiltinTypes().getCharIteratorType().getConeType(), context, reporter);
    }

    private final void checkFunctionIfSubtypeOf(FirClass $this$checkFunctionIfSubtypeOf, Name functionToCheck, ConeKotlinType supertype, CheckerContext context, DiagnosticReporter reporter) {
        if (!TypeUtilsKt.isSubtypeOf$default(ScopeUtilsKt.defaultType($this$checkFunctionIfSubtypeOf), supertype, context.getSession(), false, 4, null)) {
            return;
        }
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope($this$checkFunctionIfSubtypeOf, context);
        List<FirNamedFunctionSymbol> overridesWithSameName = FirScopeKt.getFunctions(scope2, functionToCheck);
        for (FirNamedFunctionSymbol function2 : overridesWithSameName) {
            boolean bl;
            block5: {
                Collection<FirFunctionSymbol<?>> overridden = FirHelpersKt.overriddenFunctions(function2, $this$checkFunctionIfSubtypeOf.getSymbol(), context);
                if (overridden.size() <= 1) continue;
                Iterable $this$any$iv = overridden;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getCallableId().getClassId(), ConeTypeUtilsKt.getClassId(supertype))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkFunctionIfSubtypeOf.getSource(), FirJsErrors.INSTANCE.getWRONG_MULTIPLE_INHERITANCE(), (Object)function2, (DiagnosticContext)context, null, 16, null);
        }
    }

    public /* synthetic */ FirJsMultipleInheritanceChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final class ForExpectClass
    extends FirJsMultipleInheritanceChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }

    public static final class Regular
    extends FirJsMultipleInheritanceChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }
}

