/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsModuleChecker INSTANCE = new FirJsModuleChecker();

    private FirJsModuleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Object object;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.checkSuperClass(declaration, context, reporter);
        if (declaration instanceof FirFile || !this.isEitherModuleOrNonModule(declaration, context.getSession())) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), null, 8, null);
        }
        if ((object = FirHelpersKt.closestNonLocalWith(context, declaration)) == null || (object = ((FirDeclaration)object).getSymbol()) == null) {
            return;
        }
        Object closestNonLocal = object;
        if (!FirJsHelpersKt.isNativeObject(closestNonLocal, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_NATIVE(), null, 8, null);
        }
        if (FirHelpersKt.isTopLevel(context)) {
            FirFile firFile = context.getContainingFile();
            boolean bl = firFile != null ? this.isEitherModuleOrNonModule(firFile, context.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), null, 8, null);
            }
        }
    }

    private final void checkSuperClass(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        Object v3;
        Object superClassSymbol;
        block4: {
            FirClass firClass = declaration instanceof FirClass ? (FirClass)declaration : null;
            if (firClass == null) {
                return;
            }
            FirClass classDeclaration = firClass;
            Object object = FirJsHelpersKt.superClassNotAny(classDeclaration, context.getSession());
            if (object == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeType)object, context.getSession())) == null) {
                return;
            }
            superClassSymbol = object;
            Iterable $this$firstOrNull$iv = classDeclaration.getSuperTypeRefs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(it);
                if (!Intrinsics.areEqual(coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context.getSession()) : null, superClassSymbol)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        FirTypeRef superClassRef = v3;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)superClassSymbol;
        Object object = superClassRef;
        if (object == null || (object = ((FirTypeRef)object).getSource()) == null) {
            object = ((FirClass)declaration).getSource();
        }
        FirJsModuleCheckUtilsKt.checkJsModuleUsage(firBasedSymbol, context, reporter, (AbstractKtSourceElement)object);
    }

    private final boolean isEitherModuleOrNonModule(FirDeclaration $this$isEitherModuleOrNonModule, FirSession session) {
        return FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsModule, session) || FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsNonModule, session);
    }
}

