/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

public abstract class FirJsInheritanceFunctionChecker
extends FirDeclarationChecker<FirFunction> {
    private FirJsInheritanceFunctionChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.isNotEffectivelyExternalFunctionButOverridesExternal(declaration, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS(), null, 8, null);
        }
    }

    private final boolean isNotEffectivelyExternalFunctionButOverridesExternal(FirDeclaration $this$isNotEffectivelyExternalFunctionButOverridesExternal, CheckerContext context) {
        if (!($this$isNotEffectivelyExternalFunctionButOverridesExternal instanceof FirFunction) || FirJsHelpersKt.isEffectivelyExternal((FirBasedSymbol)((FirFunction)$this$isNotEffectivelyExternalFunctionButOverridesExternal).getSymbol(), context)) {
            return false;
        }
        return FirJsHelpersKt.isOverridingExternalWithOptionalParams(((FirFunction)$this$isNotEffectivelyExternalFunctionButOverridesExternal).getSymbol(), context);
    }

    public /* synthetic */ FirJsInheritanceFunctionChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final class ForExpectClass
    extends FirJsInheritanceFunctionChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
            boolean bl;
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirDeclaration firDeclaration = CollectionsKt.last(context.getContainingDeclarations());
            FirClass firClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
            if (firClass != null) {
                FirMemberDeclaration $this$isExpect$iv = firClass;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }

    public static final class Regular
    extends FirJsInheritanceFunctionChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
            boolean bl;
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirDeclaration firDeclaration = CollectionsKt.last(context.getContainingDeclarations());
            FirClass firClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
            if (firClass != null) {
                FirMemberDeclaration $this$isExpect$iv = firClass;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }
}

