/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

public abstract class FirJsInheritanceClassChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsInheritanceClassChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        FirNamedFunctionSymbol fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirSession session = context.getSession();
        boolean isEffectivelyExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration.getSymbol(), session);
        if (isEffectivelyExternal && declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block13: {
                Iterator $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = FirDeclarationUtilKt.getSuperConeTypes(declaration);
                boolean $i$f$filterNot = false;
                void var9_10 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl2 = false;
                    if (ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(it) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable(it) || ConeBuiltinTypeUtilsKt.isEnum(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirRegularClassSymbol it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(it, session);
                    if ((firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, session) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superTypes2 = (List)destination$iv$iv;
                Iterable $this$any$iv = superTypes2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirWebCommonHelpersKt.isEffectivelyExternal(it, session))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), null, 8, null);
            }
        }
        if (!isEffectivelyExternal && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams(declaration, context)) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE(), (Object)fakeOverriddenMethod, null, 16, null);
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface)) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(declaration);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl7 = false;
                        if (!(this.isBuiltinFunctionalTypeOrSubtype(it, session) && !this.isSuspendFunctionTypeOrSubtype(it, session))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getIMPLEMENTING_FUNCTION_INTERFACE(), null, 8, null);
            }
        }
    }

    private final boolean isBuiltinFunctionalTypeOrSubtype(ConeClassLikeType $this$isBuiltinFunctionalTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244.isBuiltinFunctionTypeOrSubtype($this$isBuiltinFunctionalTypeOrSubtype);
    }

    private final boolean isSuspendFunctionTypeOrSubtype(ConeClassLikeType $this$isSuspendFunctionTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, arg_0 -> FirJsInheritanceClassChecker.isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(session, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final FirNamedFunctionSymbol findFakeMethodOverridingExternalWithOptionalParams(FirClass $this$findFakeMethodOverridingExternalWithOptionalParams, CheckerContext context) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope($this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol(), context);
            Iterable iterable = FirContainingNamesAwareScopeKt.collectAllFunctions(scope2);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirIntersectionOverrideFunctionSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv$iv;
                boolean bl = false;
                FirClassLikeSymbol<?> container = FirHelpersKt.getContainingClassSymbol(it);
                if (!(Intrinsics.areEqual(container, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol()) && !it.getIntersections().isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members2 = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv;
                boolean bl = false;
                if (!FirJsHelpersKt.isOverridingExternalWithOptionalParams(it, context)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(FirSession $session, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(it, $session);
    }

    public /* synthetic */ FirJsInheritanceClassChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final class ForExpectClass
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }

    public static final class Regular
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }
}

