/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

public abstract class FirJsExternalInheritorOnlyChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsExternalInheritorOnlyChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    private final void forEachParents(FirClass $this$forEachParents, CheckerContext context, Function1<? super FirRegularClassSymbol, Unit> f2) {
        List todo = CollectionsKt.toMutableList((Collection)FirDeclarationUtilKt.getSuperConeTypes($this$forEachParents));
        HashSet<FirRegularClassSymbol> done = new HashSet<FirRegularClassSymbol>();
        while (!((Collection)todo).isEmpty()) {
            FirRegularClassSymbol classSymbol;
            if (ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeType)AddToStdlibKt.popLast(todo), context.getSession()) == null || !done.add(classSymbol)) continue;
            f2.invoke(classSymbol);
            Iterable $this$mapNotNullTo$iv = classSymbol.getResolvedSuperTypeRefs();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeClassLikeType it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = it.getConeType();
                if ((coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                ((Collection)todo).add(it$iv);
            }
        }
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!FirJsHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration.getSymbol(), context)) {
            this.forEachParents(declaration, context, arg_0 -> FirJsExternalInheritorOnlyChecker.check$lambda$1(context, reporter, declaration, arg_0));
        }
    }

    private static final Unit check$lambda$1(CheckerContext $context, DiagnosticReporter $reporter, FirClass $declaration, FirRegularClassSymbol parent2) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        if (FirAnnotationUtilsKt.hasAnnotation(parent2, JsStandardClassIds.Annotations.JsExternalInheritorsOnly, $context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)$declaration.getSource(), FirJsErrors.INSTANCE.getJS_EXTERNAL_INHERITORS_ONLY(), (Object)parent2, $declaration.getSymbol(), null, 32, null);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirJsExternalInheritorOnlyChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final class ForExpectClass
    extends FirJsExternalInheritorOnlyChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }

    public static final class Regular
    extends FirJsExternalInheritorOnlyChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context, reporter, declaration);
        }
    }
}

