/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsExternalFileChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExternalFileChecker INSTANCE = new FirJsExternalFileChecker();

    private FirJsExternalFileChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Object object;
        block8: {
            block7: {
                Object v2;
                block6: {
                    Intrinsics.checkNotNullParameter(context, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Object object2 = FirHelpersKt.closestNonLocalWith(context, declaration);
                    if (object2 == null || (object2 = ((FirDeclaration)object2).getSymbol()) == null) {
                        return;
                    }
                    Object closestNonLocal = object2;
                    if (FirJsHelpersKt.isNativeObject(closestNonLocal, context) || closestNonLocal instanceof FirTypeAliasSymbol || !FirHelpersKt.isTopLevel(context)) {
                        return;
                    }
                    object = context.getContainingFile();
                    if (object == null || (object = ((FirFile)object).getAnnotations()) == null) break block7;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl = false;
                        if (!CollectionsKt.contains((Iterable)JsStandardClassIds.Annotations.annotationsRequiringExternal, FirAnnotationUtilsKt.toAnnotationClassId(it, context.getSession()))) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                if ((object = (FirAnnotation)v2) != null) break block8;
            }
            return;
        }
        Object targetAnnotations = object;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNON_EXTERNAL_DECLARATION_IN_INAPPROPRIATE_FILE(), (Object)FirTypeUtilsKt.getResolvedType((FirExpression)targetAnnotations), null, 16, null);
    }
}

