/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

public final class FirJsExportedActualMatchExpectChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportedActualMatchExpectChecker INSTANCE = new FirJsExportedActualMatchExpectChecker();

    private FirJsExportedActualMatchExpectChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        FirBasedSymbol correspondingActualDeclaration;
        FirBasedSymbol firBasedSymbol;
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> expectForActualMatchingData;
        Object object;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowExpectDeclarationsInJsExport) || !(declaration instanceof FirMemberDeclaration)) break block9;
                FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isActual = false;
                if ($this$isActual$iv.getStatus().isActual()) break block10;
            }
            return;
        }
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<Object>>> map2 = ExpectActualAttributesKt.getExpectForActual(((FirMemberDeclaration)declaration).getSymbol());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        if ((object = (expectForActualMatchingData = map2).get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE)) == null || (object = CollectionsKt.singleOrNull(object)) == null) {
            return;
        }
        Object correspondingExpectDeclaration = object;
        if ((FirMemberDeclaration)declaration instanceof FirTypeAlias) {
            FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(((FirTypeAlias)declaration).getExpandedTypeRef())), context.getSession());
            if (firClassSymbol == null) {
                return;
            }
            firBasedSymbol = firClassSymbol;
        } else {
            firBasedSymbol = correspondingActualDeclaration = ((FirMemberDeclaration)declaration).getSymbol();
        }
        if (FirJsHelpersKt.isExportedObject(correspondingExpectDeclaration, context) && !FirJsHelpersKt.isExportedObject(correspondingActualDeclaration, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirMemberDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getNOT_EXPORTED_ACTUAL_DECLARATION_WHILE_EXPECT_IS_EXPORTED(), null, 8, null);
        }
    }
}

