/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;

public final class FirJsExportDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportDeclarationChecker INSTANCE = new FirJsExportDeclarationChecker();

    private FirJsExportDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!FirJsHelpersKt.isExportedObject(declaration.getSymbol(), context) || !(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        boolean hasJsName = FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsName, context.getSession());
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowExpectDeclarationsInJsExport)) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "expect");
            }
        }
        this.validateDeclarationOnConsumableName((FirMemberDeclaration)declaration, context, reporter);
        FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)declaration;
        if (firMemberDeclaration instanceof FirFunction) {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external function");
                return;
            }
            for (FirTypeParameterRef typeParameter : ((FirFunction)declaration).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context, declaration, reporter, typeParameter);
            }
            if (this.isInlineWithReified((FirCallableSymbol)((FirFunction)declaration).getSymbol())) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "inline function with reified type parameters");
                return;
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "suspend function");
                return;
            }
            if (declaration instanceof FirConstructor && !((FirConstructor)declaration).isPrimary() && !hasJsName) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "secondary constructor without @JsName");
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            for (FirValueParameter parameter : ((FirFunction)declaration).getValueParameters()) {
                FirJsExportDeclarationChecker.check$checkValueParameter(context, declaration, reporter, parameter);
            }
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirFunction)declaration).getReturnTypeRef());
            if (!(declaration instanceof FirConstructor) && !FirJsExportDeclarationChecker.isExportableReturn$default(this, returnType, context.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"return", (Object)returnType, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirProperty) {
            boolean bl;
            FirClassSymbol containingClass;
            KtSourceElement ktSourceElement = ((FirProperty)declaration).getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                return;
            }
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal22 = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external property");
                return;
            }
            if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "extension property");
                return;
            }
            FirClassLikeSymbol<?> $i$f$isExternal22 = FirHelpersKt.getContainingClassSymbol(declaration);
            FirClassSymbol firClassSymbol = containingClass = $i$f$isExternal22 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$isExternal22 : null;
            if (firClassSymbol != null) {
                FirClassSymbol firClassSymbol2 = firClassSymbol;
                FirProperty firProperty = (FirProperty)declaration;
                FirClassSymbol p0 = firClassSymbol2;
                boolean bl2 = false;
                bl = UtilsKt.isEnumEntries((FirVariable)firProperty, p0);
            } else {
                bl = false;
            }
            boolean enumEntriesProperty = bl;
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirProperty)declaration).getReturnTypeRef());
            if (!enumEntriesProperty && !FirJsExportDeclarationChecker.isExportable$default(this, returnType, context.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"property", (Object)returnType, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirClass) {
            Object wrongDeclaration;
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                    case 1: {
                        string = "external class";
                        break;
                    }
                    case 2: {
                        string = null;
                        break;
                    }
                    case 3: {
                        string = "external enum class";
                        break;
                    }
                    case 4: {
                        string = "external enum entry";
                        break;
                    }
                    case 5: {
                        string = "external annotation class";
                        break;
                    }
                    case 6: {
                        string = "external object";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                wrongDeclaration = string;
                if (wrongDeclaration != null) {
                    FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, (String)wrongDeclaration);
                    return;
                }
            }
            wrongDeclaration = ((FirClass)declaration).getTypeParameters().iterator();
            while (wrongDeclaration.hasNext()) {
                FirTypeParameterRef typeParameter = wrongDeclaration.next();
                FirJsExportDeclarationChecker.check$checkTypeParameter(context, declaration, reporter, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                case 5: {
                    Object object = "annotation class";
                    break;
                }
                case 1: {
                    Object object;
                    if (this.isInsideInterface(context)) {
                        object = "nested class inside exported interface";
                        break;
                    }
                    FirClass $this$isInlineOrValue$iv = (FirClass)declaration;
                    boolean $i$f$isInlineOrValue = false;
                    if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                        object = "value class";
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    Object object = wrongDeclaration = this.isInsideInterface(context) && !((FirClass)declaration).getStatus().isCompanion() ? "nested/inner declaration inside exported interface" : null;
                }
            }
            if (this.isInsideInterface(context) && ((FirClass)declaration).getStatus().isCompanion() && !Intrinsics.areEqual(FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getNAMED_COMPANION_IN_EXPORTED_INTERFACE(), null, 8, null);
            }
            if (wrongDeclaration != null) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, (String)wrongDeclaration);
            }
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external declaration");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideInterface(CheckerContext $this$isInsideInterface) {
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull($this$isInsideInterface.getContainingDeclarations());
        if (!(firDeclaration instanceof FirClass)) return false;
        FirClass firClass = (FirClass)firDeclaration;
        FirClass parent2 = firClass;
        if (parent2 == null) return false;
        FirClass $this$isInterface$iv = parent2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    private final boolean isInlineWithReified(FirCallableSymbol<?> $this$isInlineWithReified) {
        boolean bl;
        block5: {
            if ($this$isInlineWithReified instanceof FirPropertyAccessorSymbol) {
                bl = this.isInlineWithReified(((FirPropertyAccessorSymbol)$this$isInlineWithReified).getPropertySymbol());
            } else {
                Iterable $this$any$iv = $this$isInlineWithReified.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final boolean isExportableReturn(ConeKotlinType $this$isExportableReturn, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        return ConeBuiltinTypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportableReturn(coneKotlinType, firSession, set);
    }

    private final boolean isExportableTypeArguments(ConeKotlinType $this$isExportableTypeArguments, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        if ($this$isExportableTypeArguments.getTypeArguments().length == 0) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$isExportableTypeArguments, session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        int n2 = $this$isExportableTypeArguments.getTypeArguments().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FirTypeParameterSymbol parameter;
            if (CollectionsKt.getOrNull(symbol.getTypeParameterSymbols(), i2) == null) {
                return false;
            }
            if (this.isExportable($this$isExportableTypeArguments.getTypeArguments()[i2], session, parameter, currentlyProcessed)) continue;
            return false;
        }
        return true;
    }

    private final boolean isExportable(ConeTypeProjection $this$isExportable, FirSession session, FirTypeParameterSymbol declarationSite, Set<ConeKotlinType> currentlyProcessed) {
        ConeKotlinType coneKotlinType;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$isExportable.getKind().ordinal()]) {
            case 1: {
                coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                break;
            }
            case 2: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 1) {
                    coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                    break;
                }
                coneKotlinType = null;
                break;
            }
            case 3: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 2) {
                    coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                    break;
                }
                coneKotlinType = null;
                break;
            }
            case 4: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 3) {
                    coneKotlinType = null;
                    break;
                }
                coneKotlinType = TypeUtilsKt.getProjectionForRawType(declarationSite, session, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType typeFromProjection = coneKotlinType;
        return declarationSite.getVariance() == Variance.OUT_VARIANCE && ConeBuiltinTypeUtilsKt.isUnit(typeFromProjection) || this.isExportable(typeFromProjection, session, currentlyProcessed);
    }

    private final boolean isExportable(ConeKotlinType $this$isExportable, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        boolean bl;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default($this$isExportable, session, null, 2, null);
        boolean isFunctionType = FunctionalTypeUtilsKt.isBasicFunctionType(expandedType, session);
        boolean isExportableArgs = this.isExportableTypeArguments(expandedType, session, currentlyProcessed);
        currentlyProcessed.remove($this$isExportable);
        if (isFunctionType || !isExportableArgs) {
            return isExportableArgs;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default(expandedType, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
        boolean isPrimitiveExportableType = ConeBuiltinTypeUtilsKt.isAny(nonNullable) || ConeBuiltinTypeUtilsKt.isNullableAny(nonNullable) || nonNullable instanceof ConeDynamicType || this.isPrimitiveExportableConeKotlinType(nonNullable);
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(expandedType, session);
        if (isPrimitiveExportableType) {
            bl = true;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = symbol;
            bl = !(firClassifierSymbol != null ? FirDeclarationUtilKt.isMemberDeclaration((FirBasedSymbol)firClassifierSymbol) : false) ? false : (ConeBuiltinTypeUtilsKt.isEnum(expandedType) ? true : FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)symbol, session) || FirJsHelpersKt.isExportedObject((FirBasedSymbol)symbol, session));
        }
        return bl;
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneKotlinType, firSession, set);
    }

    private final boolean isPrimitiveExportableConeKotlinType(ConeKotlinType $this$isPrimitiveExportableConeKotlinType) {
        return $this$isPrimitiveExportableConeKotlinType instanceof ConeTypeParameterType || ConeBuiltinTypeUtilsKt.isBoolean($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isString($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveNumberOrNullableType($this$isPrimitiveExportableConeKotlinType) && !ConeBuiltinTypeUtilsKt.isLong($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMap($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableMap($this$isPrimitiveExportableConeKotlinType);
    }

    private final void validateDeclarationOnConsumableName(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        if (!FirHelpersKt.isTopLevel(context) || FirDeclarationUtilKt.getNameOrSpecialName(declaration).isSpecial()) {
            return;
        }
        FirExpression jsNameArgument = FirHelpersKt.getAnnotationFirstArgument(declaration.getSymbol(), JsStandardClassIds.Annotations.JsName, context.getSession());
        Object object = jsNameArgument;
        if (object == null || (object = ((FirExpression)object).getSource()) == null) {
            object = declaration.getSource();
        }
        Object reportTarget = object;
        FirLiteralExpression firLiteralExpression = jsNameArgument instanceof FirLiteralExpression ? (FirLiteralExpression)jsNameArgument : null;
        Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            String string2 = FirDeclarationUtilKt.getNameOrSpecialName(declaration).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        }
        String name = string;
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name) && Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name), name)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportTarget, FirJsErrors.INSTANCE.getNON_CONSUMABLE_EXPORTED_IDENTIFIER(), (Object)name, (DiagnosticContext)context, null, 16, null);
    }

    private static final void check$checkTypeParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirTypeParameterRef typeParameter) {
        if (typeParameter instanceof FirConstructedClassTypeParameterRef) {
            return;
        }
        for (FirResolvedTypeRef upperBound : typeParameter.getSymbol().getResolvedBounds()) {
            if (FirJsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound.getConeType(), $context.getSession(), null, 2, null)) continue;
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null && (ktSourceElement = typeParameter.getSource()) == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"upper bound", (Object)upperBound.getConeType(), null, 32, null);
        }
    }

    private static final void check$checkValueParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirValueParameter valueParameter2) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
        if (!FirJsExportDeclarationChecker.isExportable$default(INSTANCE, type2, $context.getSession(), null, 2, null)) {
            KtSourceElement ktSourceElement = valueParameter2.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"parameter", (Object)type2, null, 32, null);
        }
    }

    private static final void check$reportWrongExportedDeclaration(CheckerContext $context, DiagnosticReporter $reporter, FirDeclaration $declaration, String kind) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirMemberDeclaration)$declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXPORTED_DECLARATION(), (Object)kind, null, 16, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

