/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.DelegateFieldsMapKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

public final class FirJsDynamicDeclarationChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirJsDynamicDeclarationChecker INSTANCE = new FirJsDynamicDeclarationChecker();

    private FirJsDynamicDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Map<Integer, FirFieldSymbol> map2 = DelegateFieldsMapKt.getDelegateFieldsMap(declaration);
        if (map2 == null) {
            return;
        }
        Map<Integer, FirFieldSymbol> delegatedFields = map2;
        Iterator<Map.Entry<Integer, FirFieldSymbol>> iterator2 = delegatedFields.entrySet().iterator();
        while (iterator2.hasNext()) {
            FirExpression initializer;
            FirFieldSymbol delegate = iterator2.next().getValue();
            if (((FirField)delegate.getFir()).getInitializer() == null || !(FirTypeUtilsKt.getResolvedType(initializer) instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)initializer.getSource(), FirJsErrors.INSTANCE.getDELEGATION_BY_DYNAMIC(), null, 8, null);
        }
    }
}

