/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableName;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;

public final class FirJsBuiltinNameClashChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsBuiltinNameClashChecker INSTANCE = new FirJsBuiltinNameClashChecker();
    @NotNull
    private static final Set<String> PROHIBITED_STATIC_NAMES;
    @NotNull
    private static final Set<String> PROHIBITED_MEMBER_NAMES;

    private FirJsBuiltinNameClashChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (FirJsHelpersKt.isNativeObject(declaration.getSymbol(), context.getSession())) {
            return;
        }
        if (FirHelpersKt.getContainingClassSymbol(declaration) == null) {
            return;
        }
        FirJsStableName firJsStableName = FirJsStableName.Companion.createStableNameOrNull(declaration.getSymbol(), context.getSession());
        if (firJsStableName == null) {
            return;
        }
        FirJsStableName stableName = firJsStableName;
        if (declaration instanceof FirClassLikeDeclaration && PROHIBITED_STATIC_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirClassLikeDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Function." + stableName), null, 16, null);
        }
        if (declaration instanceof FirCallableDeclaration && PROHIBITED_MEMBER_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Object.prototype." + stableName), null, 16, null);
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }
}

