/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers;

import java.util.Collection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.name.Name;

public final class FirJsStableName {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final FirBasedSymbol<?> symbol;
    private final boolean canBeMangled;
    private final boolean isPresentInGeneratedCode;

    public FirJsStableName(@NotNull String name, @NotNull FirBasedSymbol<?> symbol, boolean canBeMangled, boolean isPresentInGeneratedCode) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        this.name = name;
        this.symbol = symbol;
        this.canBeMangled = canBeMangled;
        this.isPresentInGeneratedCode = isPresentInGeneratedCode;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final FirBasedSymbol<?> getSymbol() {
        return this.symbol;
    }

    public final boolean isPresentInGeneratedCode() {
        return this.isPresentInGeneratedCode;
    }

    private final boolean doesJSManglingChangeName(FirBasedSymbol<?> $this$doesJSManglingChangeName) {
        FirBasedSymbol<?> firBasedSymbol = $this$doesJSManglingChangeName;
        return firBasedSymbol instanceof FirFunctionSymbol ? FirCallableSymbolKt.isExtension((FirCallableSymbol)$this$doesJSManglingChangeName) || !((Collection)((FirFunctionSymbol)$this$doesJSManglingChangeName).getValueParameterSymbols()).isEmpty() || FirCallableSymbolKt.getHasContextParameters((FirCallableSymbol)$this$doesJSManglingChangeName) || !((Collection)((FirFunctionSymbol)$this$doesJSManglingChangeName).getTypeParameterSymbols()).isEmpty() : (firBasedSymbol instanceof FirPropertySymbol ? FirCallableSymbolKt.isExtension((FirCallableSymbol)$this$doesJSManglingChangeName) || FirCallableSymbolKt.getHasContextParameters((FirCallableSymbol)$this$doesJSManglingChangeName) : false);
    }

    private final boolean shouldClashBeCaughtByCommonFrontendCheck(FirBasedSymbol<?> lhs, FirBasedSymbol<?> rhs) {
        return lhs instanceof FirFunctionSymbol && rhs instanceof FirFunctionSymbol || lhs instanceof FirPropertySymbol && rhs instanceof FirPropertySymbol || lhs instanceof FirClassLikeSymbol && rhs instanceof FirClassLikeSymbol;
    }

    private final boolean isExternalRedeclarable() {
        boolean bl;
        if (this.isPresentInGeneratedCode) {
            bl = false;
        } else {
            boolean bl2;
            FirBasedSymbol<?> firBasedSymbol = this.symbol;
            FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
            if (firCallableSymbol != null) {
                FirCallableSymbol $this$isFinal$iv = firCallableSymbol;
                boolean $i$f$isFinal = false;
                bl2 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
            } else {
                bl2 = false;
            }
            bl = bl2 ? true : this.symbol instanceof FirClassLikeSymbol;
        }
        return bl;
    }

    public final boolean clashesWith(@NotNull FirJsStableName other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.symbol == other.symbol ? false : (!Intrinsics.areEqual(this.name, other.name) ? false : (!this.isPresentInGeneratedCode && !other.isPresentInGeneratedCode ? false : (this.isExternalRedeclarable() || other.isExternalRedeclarable() ? false : (FirJsHelpersKt.isActual(this.symbol) != FirJsHelpersKt.isActual(other.symbol) ? false : (FirJsHelpersKt.isExpect(this.symbol) != FirJsHelpersKt.isExpect(other.symbol) ? false : (this.canBeMangled && this.doesJSManglingChangeName(this.symbol) ? false : (other.canBeMangled && this.doesJSManglingChangeName(other.symbol) ? false : !this.canBeMangled || !other.canBeMangled || !this.shouldClashBeCaughtByCommonFrontendCheck(this.symbol, other.symbol))))))));
    }

    @NotNull
    public final FirJsStableName copy(@NotNull String name, @NotNull FirBasedSymbol<?> symbol, boolean canBeMangled, boolean isPresentInGeneratedCode) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return new FirJsStableName(name, symbol, canBeMangled, isPresentInGeneratedCode);
    }

    public static /* synthetic */ FirJsStableName copy$default(FirJsStableName firJsStableName, String string, FirBasedSymbol firBasedSymbol, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = firJsStableName.name;
        }
        if ((n2 & 2) != 0) {
            firBasedSymbol = firJsStableName.symbol;
        }
        if ((n2 & 4) != 0) {
            bl = firJsStableName.canBeMangled;
        }
        if ((n2 & 8) != 0) {
            bl2 = firJsStableName.isPresentInGeneratedCode;
        }
        return firJsStableName.copy(string, firBasedSymbol, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "FirJsStableName(name=" + this.name + ", symbol=" + this.symbol + ", canBeMangled=" + this.canBeMangled + ", isPresentInGeneratedCode=" + this.isPresentInGeneratedCode + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.symbol.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.canBeMangled);
        result2 = result2 * 31 + Boolean.hashCode(this.isPresentInGeneratedCode);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FirJsStableName)) {
            return false;
        }
        FirJsStableName firJsStableName = (FirJsStableName)other;
        if (!Intrinsics.areEqual(this.name, firJsStableName.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.symbol, firJsStableName.symbol)) {
            return false;
        }
        if (this.canBeMangled != firJsStableName.canBeMangled) {
            return false;
        }
        return this.isPresentInGeneratedCode == firJsStableName.isPresentInGeneratedCode;
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasPublicName(FirBasedSymbol<?> symbol, FirSession session) {
            FirBasedSymbol<?> firBasedSymbol = symbol;
            if (firBasedSymbol instanceof FirClassLikeSymbol) {
                FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)symbol;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) return false;
                return true;
            }
            if (!(firBasedSymbol instanceof FirCallableSymbol)) return false;
            FirClassLikeSymbol<?> parentClass = FirHelpersKt.getContainingClassSymbol(symbol);
            if (parentClass != null) {
                FirBasedSymbol $this$visibility$iv = (FirCallableSymbol)symbol;
                boolean $i$f$getVisibility = false;
                Visibility $i$f$isLocal = ((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
                if ($i$f$isLocal instanceof Visibilities.Public) {
                    return true;
                }
                if (!($i$f$isLocal instanceof Visibilities.Protected)) return false;
                FirClassLikeSymbol<?> $this$isFinal$iv = parentClass;
                boolean $i$f$isFinal = false;
                if ($this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                    return false;
                }
                boolean bl = false;
                if (bl) return false;
                $this$visibility$iv = parentClass;
                $i$f$getVisibility = false;
                if (!((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility().isPublicAPI()) return false;
                return true;
            }
            if (((FirCallableSymbol)symbol).getCallableId().isLocal()) return false;
            FirCallableSymbol $this$effectiveVisibility$iv = (FirCallableSymbol)symbol;
            boolean $i$f$getEffectiveVisibility = false;
            if (!$this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility().getPublicApi()) return false;
            return true;
        }

        @Nullable
        public final FirJsStableName createStableNameOrNull(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
            boolean hasStableNameInJavaScript;
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(session, "session");
            String jsName = FirJsHelpersKt.getJsName(symbol, session);
            if (jsName != null) {
                return new FirJsStableName(jsName, symbol, false, FirJsHelpersKt.isPresentInGeneratedCode(symbol, session));
            }
            FirBasedSymbol<?> firBasedSymbol = symbol;
            if (firBasedSymbol instanceof FirConstructorSymbol) {
                return null;
            }
            if (firBasedSymbol instanceof FirPropertyAccessorSymbol) {
                return null;
            }
            if (firBasedSymbol instanceof FirTypeAliasSymbol) {
                return null;
            }
            boolean bl = FirWebCommonHelpersKt.isEffectivelyExternal(symbol, session) ? true : (hasStableNameInJavaScript = FirJsHelpersKt.isExportedObject(symbol, session));
            if (hasStableNameInJavaScript || this.hasPublicName(symbol, session)) {
                String name;
                Name name2 = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(symbol);
                String string = name = name2 != null ? name2.getIdentifierOrNullIfSpecial() : null;
                if (name != null) {
                    return new FirJsStableName(name, symbol, !hasStableNameInJavaScript, FirJsHelpersKt.isPresentInGeneratedCode(symbol, session));
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

