/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

public final class FirJsHelpersKt {
    public static final boolean isEffectivelyExternalMember(@NotNull FirBasedSymbol<?> $this$isEffectivelyExternalMember, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExternalMember, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return $this$isEffectivelyExternalMember.getFir() instanceof FirMemberDeclaration && FirWebCommonHelpersKt.isEffectivelyExternal($this$isEffectivelyExternalMember, session);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirBasedSymbol<?> $this$isEffectivelyExternal, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExternal, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirWebCommonHelpersKt.isEffectivelyExternal($this$isEffectivelyExternal, context.getSession());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isOverridingExternalWithOptionalParams(@NotNull FirFunctionSymbol<?> $this$isOverridingExternalWithOptionalParams, @NotNull CheckerContext context) {
        void $this$filterTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter($this$isOverridingExternalWithOptionalParams, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableSymbol)$this$isOverridingExternalWithOptionalParams)) {
            FirCallableSymbol $this$modality$iv = $this$isOverridingExternalWithOptionalParams;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) {
                return false;
            }
        }
        if ((object = $this$isOverridingExternalWithOptionalParams instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)$this$isOverridingExternalWithOptionalParams : null) == null || (object = FirHelpersKt.directOverriddenFunctionsSafe((FirNamedFunctionSymbol)object, context)) == null) {
            return false;
        }
        Object overridden = object;
        Iterable $this$filter$iv = (Iterable)overridden;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirJsHelpersKt.isEffectivelyExternal(it, context)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirNamedFunctionSymbol overriddenFunction : (List)destination$iv$iv) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = overriddenFunction.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.getHasDefaultValue()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final String getJsName(@NotNull FirBasedSymbol<?> $this$getJsName, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$getJsName, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirHelpersKt.getAnnotationStringParameter($this$getJsName, JsStandardClassIds.Annotations.JsName, session);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        if (((CharSequence)name).length() == 0) {
            return "_";
        }
        char it = StringsKt.first(name);
        boolean $i$a$-let-FirJsHelpersKt$sanitizeName$first$22 = false;
        char first2 = IdentifierPolicyKt.isES5IdentifierStart(it) ? it : (char)'_';
        CharSequence charSequence = StringsKt.drop(name, 1);
        StringBuilder stringBuilder = new StringBuilder().append(first2);
        boolean $i$f$map = false;
        void $i$a$-let-FirJsHelpersKt$sanitizeName$first$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i2 = 0; i2 < $this$mapTo$iv$iv.length(); ++i2) {
            char it2;
            char item$iv$iv;
            char c2 = item$iv$iv = $this$mapTo$iv$iv.charAt(i2);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(IdentifierPolicyKt.isES5IdentifierPart(it2) ? it2 : (char)'_'));
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null)).toString();
    }

    public static final boolean isNativeObject(@NotNull FirBasedSymbol<?> $this$isNativeObject, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isNativeObject, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if (FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isNativeObject, JsStandardClassIds.Annotations.JsNative, session) || FirWebCommonHelpersKt.isEffectivelyExternal($this$isNativeObject, session)) {
            return true;
        }
        if ($this$isNativeObject instanceof FirPropertyAccessorSymbol) {
            FirPropertySymbol property = ((FirPropertyAccessorSymbol)$this$isNativeObject).getPropertySymbol();
            return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass(property, JsStandardClassIds.Annotations.JsNative, session);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNativeInterface(@NotNull FirBasedSymbol<?> $this$isNativeInterface, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isNativeInterface, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!FirJsHelpersKt.isNativeObject($this$isNativeInterface, session)) return false;
        Object obj = $this$isNativeInterface.getFir();
        if (!(obj instanceof FirClass)) return false;
        FirClass firClass = (FirClass)obj;
        if (firClass == null) return false;
        FirClass $this$isInterface$iv = firClass;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    public static final boolean isLibraryObject(@NotNull FirBasedSymbol<?> $this$isLibraryObject, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isLibraryObject, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isLibraryObject, JsStandardClassIds.Annotations.JsLibrary, session);
    }

    public static final boolean isPresentInGeneratedCode(@NotNull FirBasedSymbol<?> $this$isPresentInGeneratedCode, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isPresentInGeneratedCode, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return !FirJsHelpersKt.isNativeObject($this$isPresentInGeneratedCode, session) && !FirJsHelpersKt.isLibraryObject($this$isPresentInGeneratedCode, session);
    }

    public static final boolean isExpect(@NotNull FirBasedSymbol<?> $this$isExpect) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isExpect, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isExpect;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            FirCallableSymbol $this$isExpect$iv = (FirCallableSymbol)$this$isExpect;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else if (firBasedSymbol instanceof FirClassSymbol) {
            FirClassLikeSymbol $this$isExpect$iv = (FirClassLikeSymbol)$this$isExpect;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isActual(@NotNull FirBasedSymbol<?> $this$isActual) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isActual, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isActual;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            FirCallableSymbol $this$isActual$iv = (FirCallableSymbol)$this$isActual;
            boolean $i$f$isActual = false;
            bl = $this$isActual$iv.getRawStatus().isActual();
        } else if (firBasedSymbol instanceof FirClassSymbol) {
            FirClassLikeSymbol $this$isActual$iv = (FirClassLikeSymbol)$this$isActual;
            boolean $i$f$isActual = false;
            bl = $this$isActual$iv.getRawStatus().isActual();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isPredefinedObject(@NotNull FirBasedSymbol<?> $this$isPredefinedObject, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isPredefinedObject, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if ($this$isPredefinedObject.getFir() instanceof FirMemberDeclaration && FirJsHelpersKt.isExpect($this$isPredefinedObject)) {
            return true;
        }
        if (FirJsHelpersKt.isEffectivelyExternalMember($this$isPredefinedObject, session)) {
            return true;
        }
        for (PredefinedAnnotation annotation : PredefinedAnnotation.getEntries()) {
            if (!FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isPredefinedObject, annotation.getClassId(), session)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isExportedObject(@NotNull FirBasedSymbol<?> $this$isExportedObject, @NotNull FirSession session) {
        Object object;
        Intrinsics.checkNotNullParameter($this$isExportedObject, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Object declaration = $this$isExportedObject.getFir();
        if (declaration instanceof FirMemberDeclaration) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
            if (!Intrinsics.areEqual(visibility, Visibilities.Public.INSTANCE) && !Intrinsics.areEqual(visibility, Visibilities.Protected.INSTANCE)) {
                return false;
            }
        }
        return FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isExportedObject, JsStandardClassIds.Annotations.JsExportIgnore, session) ? false : (FirHelpersKt.hasAnnotationOrInsideAnnotatedClass($this$isExportedObject, JsStandardClassIds.Annotations.JsExport, session) ? true : ((object = FirJsHelpersKt.getContainingFile($this$isExportedObject)) != null && (object = ((FirFile)object).getSymbol()) != null ? FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)object, JsStandardClassIds.Annotations.JsExport, session) : false));
    }

    @Nullable
    public static final FirFile getContainingFile(@NotNull FirBasedSymbol<?> $this$getContainingFile) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter($this$getContainingFile, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$getContainingFile;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            firFile = FirProviderKt.getFirProvider(((FirCallableSymbol)$this$getContainingFile).getModuleData().getSession()).getFirCallableContainerFile((FirCallableSymbol)$this$getContainingFile);
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            firFile = FirProviderKt.getFirProvider(((FirClassLikeSymbol)$this$getContainingFile).getModuleData().getSession()).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)$this$getContainingFile);
        } else {
            return null;
        }
        return firFile;
    }

    public static final boolean isNativeObject(@NotNull FirBasedSymbol<?> $this$isNativeObject, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$isNativeObject, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirJsHelpersKt.isNativeObject($this$isNativeObject, context.getSession());
    }

    public static final boolean isPredefinedObject(@NotNull FirBasedSymbol<?> $this$isPredefinedObject, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$isPredefinedObject, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirJsHelpersKt.isPredefinedObject($this$isPredefinedObject, context.getSession());
    }

    public static final boolean isExportedObject(@NotNull FirBasedSymbol<?> $this$isExportedObject, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$isExportedObject, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return FirJsHelpersKt.isExportedObject($this$isExportedObject, context.getSession());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConeClassLikeType superClassNotAny(@NotNull FirClass $this$superClassNotAny, @NotNull FirSession session) {
        Object v1;
        block2: {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$superClassNotAny, "<this>");
            Intrinsics.checkNotNullParameter(session, "session");
            Iterable $this$filterNot$iv = FirDeclarationUtilKt.getSuperConeTypes($this$superClassNotAny);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                boolean bl = false;
                if (ConeBuiltinTypeUtilsKt.isAny(it) || ConeBuiltinTypeUtilsKt.isNullableAny(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e2 : iterable2) {
                ConeClassLikeType it = (ConeClassLikeType)e2;
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(it, session);
                if (!((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.CLASS)) continue;
                v1 = e2;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final FirBasedSymbol<?> getRootClassLikeSymbolOrSelf(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        FirBasedSymbol firBasedSymbol;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(symbol, "symbol");
                Intrinsics.checkNotNullParameter(session, "session");
                firBasedSymbol = FirHelpersKt.getContainingClassSymbol(symbol);
                if (firBasedSymbol == null) break block2;
                FirClassLikeSymbol<?> it = firBasedSymbol;
                boolean bl = false;
                FirBasedSymbol<?> firBasedSymbol2 = FirJsHelpersKt.getRootClassLikeSymbolOrSelf((FirBasedSymbol)it, session);
                firBasedSymbol = firBasedSymbol2;
                if (firBasedSymbol2 != null) break block3;
            }
            firBasedSymbol = symbol;
        }
        return firBasedSymbol;
    }
}

